// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The edition capability.
 */
@Fluent
public final class EditionCapability implements JsonSerializable<EditionCapability> {
    /*
     * The database edition name.
     */
    private String name;

    /*
     * The list of supported service objectives for the edition.
     */
    private List<ServiceObjectiveCapability> supportedServiceLevelObjectives;

    /*
     * Whether or not zone redundancy is supported for the edition.
     */
    private Boolean zoneRedundant;

    /*
     * The read scale capability for the edition.
     */
    private ReadScaleCapability readScale;

    /*
     * The list of supported storage capabilities for this edition
     */
    private List<StorageCapability> supportedStorageCapabilities;

    /*
     * The status of the capability.
     */
    private CapabilityStatus status;

    /*
     * The reason for the capability not being available.
     */
    private String reason;

    /**
     * Creates an instance of EditionCapability class.
     */
    public EditionCapability() {
    }

    /**
     * Get the name property: The database edition name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the supportedServiceLevelObjectives property: The list of supported service objectives for the edition.
     * 
     * @return the supportedServiceLevelObjectives value.
     */
    public List<ServiceObjectiveCapability> supportedServiceLevelObjectives() {
        return this.supportedServiceLevelObjectives;
    }

    /**
     * Get the zoneRedundant property: Whether or not zone redundancy is supported for the edition.
     * 
     * @return the zoneRedundant value.
     */
    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    /**
     * Get the readScale property: The read scale capability for the edition.
     * 
     * @return the readScale value.
     */
    public ReadScaleCapability readScale() {
        return this.readScale;
    }

    /**
     * Get the supportedStorageCapabilities property: The list of supported storage capabilities for this edition.
     * 
     * @return the supportedStorageCapabilities value.
     */
    public List<StorageCapability> supportedStorageCapabilities() {
        return this.supportedStorageCapabilities;
    }

    /**
     * Get the status property: The status of the capability.
     * 
     * @return the status value.
     */
    public CapabilityStatus status() {
        return this.status;
    }

    /**
     * Get the reason property: The reason for the capability not being available.
     * 
     * @return the reason value.
     */
    public String reason() {
        return this.reason;
    }

    /**
     * Set the reason property: The reason for the capability not being available.
     * 
     * @param reason the reason value to set.
     * @return the EditionCapability object itself.
     */
    public EditionCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (supportedServiceLevelObjectives() != null) {
            supportedServiceLevelObjectives().forEach(e -> e.validate());
        }
        if (readScale() != null) {
            readScale().validate();
        }
        if (supportedStorageCapabilities() != null) {
            supportedStorageCapabilities().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EditionCapability from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EditionCapability if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the EditionCapability.
     */
    public static EditionCapability fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EditionCapability deserializedEditionCapability = new EditionCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedEditionCapability.name = reader.getString();
                } else if ("supportedServiceLevelObjectives".equals(fieldName)) {
                    List<ServiceObjectiveCapability> supportedServiceLevelObjectives
                        = reader.readArray(reader1 -> ServiceObjectiveCapability.fromJson(reader1));
                    deserializedEditionCapability.supportedServiceLevelObjectives = supportedServiceLevelObjectives;
                } else if ("zoneRedundant".equals(fieldName)) {
                    deserializedEditionCapability.zoneRedundant = reader.getNullable(JsonReader::getBoolean);
                } else if ("readScale".equals(fieldName)) {
                    deserializedEditionCapability.readScale = ReadScaleCapability.fromJson(reader);
                } else if ("supportedStorageCapabilities".equals(fieldName)) {
                    List<StorageCapability> supportedStorageCapabilities
                        = reader.readArray(reader1 -> StorageCapability.fromJson(reader1));
                    deserializedEditionCapability.supportedStorageCapabilities = supportedStorageCapabilities;
                } else if ("status".equals(fieldName)) {
                    deserializedEditionCapability.status = CapabilityStatus.fromString(reader.getString());
                } else if ("reason".equals(fieldName)) {
                    deserializedEditionCapability.reason = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEditionCapability;
        });
    }
}
