// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The state of read-only routing. If enabled, connections that have application intent set to readonly in their
 * connection string may be routed to a readonly secondary replica in the same region. Not applicable to a Hyperscale
 * database within an elastic pool.
 */
public final class DatabaseReadScale extends ExpandableStringEnum<DatabaseReadScale> {
    /**
     * Static value Enabled for DatabaseReadScale.
     */
    public static final DatabaseReadScale ENABLED = fromString("Enabled");

    /**
     * Static value Disabled for DatabaseReadScale.
     */
    public static final DatabaseReadScale DISABLED = fromString("Disabled");

    /**
     * Creates a new instance of DatabaseReadScale value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public DatabaseReadScale() {
    }

    /**
     * Creates or finds a DatabaseReadScale from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding DatabaseReadScale.
     */
    public static DatabaseReadScale fromString(String name) {
        return fromString(name, DatabaseReadScale.class);
    }

    /**
     * Gets known DatabaseReadScale values.
     * 
     * @return known DatabaseReadScale values.
     */
    public static Collection<DatabaseReadScale> values() {
        return values(DatabaseReadScale.class);
    }
}
