// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of the sync database id.
 */
@Immutable
public final class SyncDatabaseIdPropertiesInner implements JsonSerializable<SyncDatabaseIdPropertiesInner> {
    /*
     * ARM resource id of sync database.
     */
    private String id;

    /**
     * Creates an instance of SyncDatabaseIdPropertiesInner class.
     */
    public SyncDatabaseIdPropertiesInner() {
    }

    /**
     * Get the id property: ARM resource id of sync database.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SyncDatabaseIdPropertiesInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SyncDatabaseIdPropertiesInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SyncDatabaseIdPropertiesInner.
     */
    public static SyncDatabaseIdPropertiesInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SyncDatabaseIdPropertiesInner deserializedSyncDatabaseIdPropertiesInner
                = new SyncDatabaseIdPropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSyncDatabaseIdPropertiesInner.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSyncDatabaseIdPropertiesInner;
        });
    }
}
