// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.BackupStorageRedundancy;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * The restorable dropped database's properties.
 */
@Immutable
public final class RestorableDroppedDatabaseProperties
    implements JsonSerializable<RestorableDroppedDatabaseProperties> {
    /*
     * The name of the database.
     */
    private String databaseName;

    /*
     * The max size of the database expressed in bytes.
     */
    private Long maxSizeBytes;

    /*
     * The creation date of the database (ISO8601 format).
     */
    private OffsetDateTime creationDate;

    /*
     * The deletion date of the database (ISO8601 format).
     */
    private OffsetDateTime deletionDate;

    /*
     * The earliest restore date of the database (ISO8601 format).
     */
    private OffsetDateTime earliestRestoreDate;

    /*
     * The storage account type used to store backups for this database.
     */
    private BackupStorageRedundancy backupStorageRedundancy;

    /**
     * Creates an instance of RestorableDroppedDatabaseProperties class.
     */
    public RestorableDroppedDatabaseProperties() {
    }

    /**
     * Get the databaseName property: The name of the database.
     * 
     * @return the databaseName value.
     */
    public String databaseName() {
        return this.databaseName;
    }

    /**
     * Get the maxSizeBytes property: The max size of the database expressed in bytes.
     * 
     * @return the maxSizeBytes value.
     */
    public Long maxSizeBytes() {
        return this.maxSizeBytes;
    }

    /**
     * Get the creationDate property: The creation date of the database (ISO8601 format).
     * 
     * @return the creationDate value.
     */
    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    /**
     * Get the deletionDate property: The deletion date of the database (ISO8601 format).
     * 
     * @return the deletionDate value.
     */
    public OffsetDateTime deletionDate() {
        return this.deletionDate;
    }

    /**
     * Get the earliestRestoreDate property: The earliest restore date of the database (ISO8601 format).
     * 
     * @return the earliestRestoreDate value.
     */
    public OffsetDateTime earliestRestoreDate() {
        return this.earliestRestoreDate;
    }

    /**
     * Get the backupStorageRedundancy property: The storage account type used to store backups for this database.
     * 
     * @return the backupStorageRedundancy value.
     */
    public BackupStorageRedundancy backupStorageRedundancy() {
        return this.backupStorageRedundancy;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RestorableDroppedDatabaseProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RestorableDroppedDatabaseProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RestorableDroppedDatabaseProperties.
     */
    public static RestorableDroppedDatabaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestorableDroppedDatabaseProperties deserializedRestorableDroppedDatabaseProperties
                = new RestorableDroppedDatabaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("databaseName".equals(fieldName)) {
                    deserializedRestorableDroppedDatabaseProperties.databaseName = reader.getString();
                } else if ("maxSizeBytes".equals(fieldName)) {
                    deserializedRestorableDroppedDatabaseProperties.maxSizeBytes
                        = reader.getNullable(JsonReader::getLong);
                } else if ("creationDate".equals(fieldName)) {
                    deserializedRestorableDroppedDatabaseProperties.creationDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("deletionDate".equals(fieldName)) {
                    deserializedRestorableDroppedDatabaseProperties.deletionDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("earliestRestoreDate".equals(fieldName)) {
                    deserializedRestorableDroppedDatabaseProperties.earliestRestoreDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("backupStorageRedundancy".equals(fieldName)) {
                    deserializedRestorableDroppedDatabaseProperties.backupStorageRedundancy
                        = BackupStorageRedundancy.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRestorableDroppedDatabaseProperties;
        });
    }
}
