// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.RecommendedSensitivityLabelUpdateKind;
import java.io.IOException;

/**
 * Properties of an operation executed on a recommended sensitivity label.
 */
@Fluent
public final class RecommendedSensitivityLabelUpdateProperties
    implements JsonSerializable<RecommendedSensitivityLabelUpdateProperties> {
    /*
     * The op property.
     */
    private RecommendedSensitivityLabelUpdateKind op;

    /*
     * Schema name of the column to update.
     */
    private String schema;

    /*
     * Table name of the column to update.
     */
    private String table;

    /*
     * Column name to update.
     */
    private String column;

    /**
     * Creates an instance of RecommendedSensitivityLabelUpdateProperties class.
     */
    public RecommendedSensitivityLabelUpdateProperties() {
    }

    /**
     * Get the op property: The op property.
     * 
     * @return the op value.
     */
    public RecommendedSensitivityLabelUpdateKind op() {
        return this.op;
    }

    /**
     * Set the op property: The op property.
     * 
     * @param op the op value to set.
     * @return the RecommendedSensitivityLabelUpdateProperties object itself.
     */
    public RecommendedSensitivityLabelUpdateProperties withOp(RecommendedSensitivityLabelUpdateKind op) {
        this.op = op;
        return this;
    }

    /**
     * Get the schema property: Schema name of the column to update.
     * 
     * @return the schema value.
     */
    public String schema() {
        return this.schema;
    }

    /**
     * Set the schema property: Schema name of the column to update.
     * 
     * @param schema the schema value to set.
     * @return the RecommendedSensitivityLabelUpdateProperties object itself.
     */
    public RecommendedSensitivityLabelUpdateProperties withSchema(String schema) {
        this.schema = schema;
        return this;
    }

    /**
     * Get the table property: Table name of the column to update.
     * 
     * @return the table value.
     */
    public String table() {
        return this.table;
    }

    /**
     * Set the table property: Table name of the column to update.
     * 
     * @param table the table value to set.
     * @return the RecommendedSensitivityLabelUpdateProperties object itself.
     */
    public RecommendedSensitivityLabelUpdateProperties withTable(String table) {
        this.table = table;
        return this;
    }

    /**
     * Get the column property: Column name to update.
     * 
     * @return the column value.
     */
    public String column() {
        return this.column;
    }

    /**
     * Set the column property: Column name to update.
     * 
     * @param column the column value to set.
     * @return the RecommendedSensitivityLabelUpdateProperties object itself.
     */
    public RecommendedSensitivityLabelUpdateProperties withColumn(String column) {
        this.column = column;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (op() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property op in model RecommendedSensitivityLabelUpdateProperties"));
        }
        if (schema() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property schema in model RecommendedSensitivityLabelUpdateProperties"));
        }
        if (table() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property table in model RecommendedSensitivityLabelUpdateProperties"));
        }
        if (column() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property column in model RecommendedSensitivityLabelUpdateProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RecommendedSensitivityLabelUpdateProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("op", this.op == null ? null : this.op.toString());
        jsonWriter.writeStringField("schema", this.schema);
        jsonWriter.writeStringField("table", this.table);
        jsonWriter.writeStringField("column", this.column);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RecommendedSensitivityLabelUpdateProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RecommendedSensitivityLabelUpdateProperties if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RecommendedSensitivityLabelUpdateProperties.
     */
    public static RecommendedSensitivityLabelUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecommendedSensitivityLabelUpdateProperties deserializedRecommendedSensitivityLabelUpdateProperties
                = new RecommendedSensitivityLabelUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("op".equals(fieldName)) {
                    deserializedRecommendedSensitivityLabelUpdateProperties.op
                        = RecommendedSensitivityLabelUpdateKind.fromString(reader.getString());
                } else if ("schema".equals(fieldName)) {
                    deserializedRecommendedSensitivityLabelUpdateProperties.schema = reader.getString();
                } else if ("table".equals(fieldName)) {
                    deserializedRecommendedSensitivityLabelUpdateProperties.table = reader.getString();
                } else if ("column".equals(fieldName)) {
                    deserializedRecommendedSensitivityLabelUpdateProperties.column = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRecommendedSensitivityLabelUpdateProperties;
        });
    }
}
