// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.QueryMetricInterval;
import java.io.IOException;
import java.util.List;

/**
 * Properties of a query execution statistics.
 */
@Fluent
public final class QueryStatisticsProperties implements JsonSerializable<QueryStatisticsProperties> {
    /*
     * Database name of the database in which this query was executed.
     */
    private String databaseName;

    /*
     * Unique query id (unique within one database).
     */
    private String queryId;

    /*
     * The start time for the metric (ISO-8601 format).
     */
    private String startTime;

    /*
     * The end time for the metric (ISO-8601 format).
     */
    private String endTime;

    /*
     * List of intervals with appropriate metric data
     */
    private List<QueryMetricInterval> intervals;

    /**
     * Creates an instance of QueryStatisticsProperties class.
     */
    public QueryStatisticsProperties() {
    }

    /**
     * Get the databaseName property: Database name of the database in which this query was executed.
     * 
     * @return the databaseName value.
     */
    public String databaseName() {
        return this.databaseName;
    }

    /**
     * Get the queryId property: Unique query id (unique within one database).
     * 
     * @return the queryId value.
     */
    public String queryId() {
        return this.queryId;
    }

    /**
     * Get the startTime property: The start time for the metric (ISO-8601 format).
     * 
     * @return the startTime value.
     */
    public String startTime() {
        return this.startTime;
    }

    /**
     * Get the endTime property: The end time for the metric (ISO-8601 format).
     * 
     * @return the endTime value.
     */
    public String endTime() {
        return this.endTime;
    }

    /**
     * Get the intervals property: List of intervals with appropriate metric data.
     * 
     * @return the intervals value.
     */
    public List<QueryMetricInterval> intervals() {
        return this.intervals;
    }

    /**
     * Set the intervals property: List of intervals with appropriate metric data.
     * 
     * @param intervals the intervals value to set.
     * @return the QueryStatisticsProperties object itself.
     */
    public QueryStatisticsProperties withIntervals(List<QueryMetricInterval> intervals) {
        this.intervals = intervals;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (intervals() != null) {
            intervals().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("intervals", this.intervals, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of QueryStatisticsProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of QueryStatisticsProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the QueryStatisticsProperties.
     */
    public static QueryStatisticsProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            QueryStatisticsProperties deserializedQueryStatisticsProperties = new QueryStatisticsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("databaseName".equals(fieldName)) {
                    deserializedQueryStatisticsProperties.databaseName = reader.getString();
                } else if ("queryId".equals(fieldName)) {
                    deserializedQueryStatisticsProperties.queryId = reader.getString();
                } else if ("startTime".equals(fieldName)) {
                    deserializedQueryStatisticsProperties.startTime = reader.getString();
                } else if ("endTime".equals(fieldName)) {
                    deserializedQueryStatisticsProperties.endTime = reader.getString();
                } else if ("intervals".equals(fieldName)) {
                    List<QueryMetricInterval> intervals
                        = reader.readArray(reader1 -> QueryMetricInterval.fromJson(reader1));
                    deserializedQueryStatisticsProperties.intervals = intervals;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedQueryStatisticsProperties;
        });
    }
}
