// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.OperationDisplay;
import com.azure.resourcemanager.sql.models.OperationOrigin;
import java.io.IOException;
import java.util.Map;

/**
 * SQL REST API operation definition.
 */
@Immutable
public final class OperationInner implements JsonSerializable<OperationInner> {
    /*
     * The name of the operation being performed on this particular object.
     */
    private String name;

    /*
     * The localized display information for this particular operation / action.
     */
    private OperationDisplay display;

    /*
     * The intended executor of the operation.
     */
    private OperationOrigin origin;

    /*
     * Additional descriptions for the operation.
     */
    private Map<String, Object> properties;

    /**
     * Creates an instance of OperationInner class.
     */
    public OperationInner() {
    }

    /**
     * Get the name property: The name of the operation being performed on this particular object.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the display property: The localized display information for this particular operation / action.
     * 
     * @return the display value.
     */
    public OperationDisplay display() {
        return this.display;
    }

    /**
     * Get the origin property: The intended executor of the operation.
     * 
     * @return the origin value.
     */
    public OperationOrigin origin() {
        return this.origin;
    }

    /**
     * Get the properties property: Additional descriptions for the operation.
     * 
     * @return the properties value.
     */
    public Map<String, Object> properties() {
        return this.properties;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (display() != null) {
            display().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OperationInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OperationInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the OperationInner.
     */
    public static OperationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OperationInner deserializedOperationInner = new OperationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedOperationInner.name = reader.getString();
                } else if ("display".equals(fieldName)) {
                    deserializedOperationInner.display = OperationDisplay.fromJson(reader);
                } else if ("origin".equals(fieldName)) {
                    deserializedOperationInner.origin = OperationOrigin.fromString(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    Map<String, Object> properties = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedOperationInner.properties = properties;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOperationInner;
        });
    }
}
