// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.LedgerDigestUploadsState;
import java.io.IOException;

/**
 * The properties of a database ledger digest upload settings.
 */
@Fluent
public final class LedgerDigestUploadsProperties implements JsonSerializable<LedgerDigestUploadsProperties> {
    /*
     * The digest storage endpoint, which must be either an Azure blob storage endpoint or an URI for Azure Confidential
     * Ledger.
     */
    private String digestStorageEndpoint;

    /*
     * Specifies the state of ledger digest upload.
     */
    private LedgerDigestUploadsState state;

    /**
     * Creates an instance of LedgerDigestUploadsProperties class.
     */
    public LedgerDigestUploadsProperties() {
    }

    /**
     * Get the digestStorageEndpoint property: The digest storage endpoint, which must be either an Azure blob storage
     * endpoint or an URI for Azure Confidential Ledger.
     * 
     * @return the digestStorageEndpoint value.
     */
    public String digestStorageEndpoint() {
        return this.digestStorageEndpoint;
    }

    /**
     * Set the digestStorageEndpoint property: The digest storage endpoint, which must be either an Azure blob storage
     * endpoint or an URI for Azure Confidential Ledger.
     * 
     * @param digestStorageEndpoint the digestStorageEndpoint value to set.
     * @return the LedgerDigestUploadsProperties object itself.
     */
    public LedgerDigestUploadsProperties withDigestStorageEndpoint(String digestStorageEndpoint) {
        this.digestStorageEndpoint = digestStorageEndpoint;
        return this;
    }

    /**
     * Get the state property: Specifies the state of ledger digest upload.
     * 
     * @return the state value.
     */
    public LedgerDigestUploadsState state() {
        return this.state;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("digestStorageEndpoint", this.digestStorageEndpoint);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LedgerDigestUploadsProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LedgerDigestUploadsProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the LedgerDigestUploadsProperties.
     */
    public static LedgerDigestUploadsProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LedgerDigestUploadsProperties deserializedLedgerDigestUploadsProperties
                = new LedgerDigestUploadsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("digestStorageEndpoint".equals(fieldName)) {
                    deserializedLedgerDigestUploadsProperties.digestStorageEndpoint = reader.getString();
                } else if ("state".equals(fieldName)) {
                    deserializedLedgerDigestUploadsProperties.state
                        = LedgerDigestUploadsState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLedgerDigestUploadsProperties;
        });
    }
}
