// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.ServerKeyType;
import java.io.IOException;

/**
 * Properties for an encryption protector execution.
 */
@Fluent
public final class EncryptionProtectorProperties implements JsonSerializable<EncryptionProtectorProperties> {
    /*
     * Subregion of the encryption protector.
     */
    private String subregion;

    /*
     * The name of the server key.
     */
    private String serverKeyName;

    /*
     * The encryption protector type like 'ServiceManaged', 'AzureKeyVault'.
     */
    private ServerKeyType serverKeyType;

    /*
     * The URI of the server key.
     */
    private String uri;

    /*
     * Thumbprint of the server key.
     */
    private String thumbprint;

    /*
     * Key auto rotation opt-in flag. Either true or false.
     */
    private Boolean autoRotationEnabled;

    /**
     * Creates an instance of EncryptionProtectorProperties class.
     */
    public EncryptionProtectorProperties() {
    }

    /**
     * Get the subregion property: Subregion of the encryption protector.
     * 
     * @return the subregion value.
     */
    public String subregion() {
        return this.subregion;
    }

    /**
     * Get the serverKeyName property: The name of the server key.
     * 
     * @return the serverKeyName value.
     */
    public String serverKeyName() {
        return this.serverKeyName;
    }

    /**
     * Set the serverKeyName property: The name of the server key.
     * 
     * @param serverKeyName the serverKeyName value to set.
     * @return the EncryptionProtectorProperties object itself.
     */
    public EncryptionProtectorProperties withServerKeyName(String serverKeyName) {
        this.serverKeyName = serverKeyName;
        return this;
    }

    /**
     * Get the serverKeyType property: The encryption protector type like 'ServiceManaged', 'AzureKeyVault'.
     * 
     * @return the serverKeyType value.
     */
    public ServerKeyType serverKeyType() {
        return this.serverKeyType;
    }

    /**
     * Set the serverKeyType property: The encryption protector type like 'ServiceManaged', 'AzureKeyVault'.
     * 
     * @param serverKeyType the serverKeyType value to set.
     * @return the EncryptionProtectorProperties object itself.
     */
    public EncryptionProtectorProperties withServerKeyType(ServerKeyType serverKeyType) {
        this.serverKeyType = serverKeyType;
        return this;
    }

    /**
     * Get the uri property: The URI of the server key.
     * 
     * @return the uri value.
     */
    public String uri() {
        return this.uri;
    }

    /**
     * Get the thumbprint property: Thumbprint of the server key.
     * 
     * @return the thumbprint value.
     */
    public String thumbprint() {
        return this.thumbprint;
    }

    /**
     * Get the autoRotationEnabled property: Key auto rotation opt-in flag. Either true or false.
     * 
     * @return the autoRotationEnabled value.
     */
    public Boolean autoRotationEnabled() {
        return this.autoRotationEnabled;
    }

    /**
     * Set the autoRotationEnabled property: Key auto rotation opt-in flag. Either true or false.
     * 
     * @param autoRotationEnabled the autoRotationEnabled value to set.
     * @return the EncryptionProtectorProperties object itself.
     */
    public EncryptionProtectorProperties withAutoRotationEnabled(Boolean autoRotationEnabled) {
        this.autoRotationEnabled = autoRotationEnabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (serverKeyType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property serverKeyType in model EncryptionProtectorProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(EncryptionProtectorProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serverKeyType", this.serverKeyType == null ? null : this.serverKeyType.toString());
        jsonWriter.writeStringField("serverKeyName", this.serverKeyName);
        jsonWriter.writeBooleanField("autoRotationEnabled", this.autoRotationEnabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EncryptionProtectorProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EncryptionProtectorProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the EncryptionProtectorProperties.
     */
    public static EncryptionProtectorProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EncryptionProtectorProperties deserializedEncryptionProtectorProperties
                = new EncryptionProtectorProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("serverKeyType".equals(fieldName)) {
                    deserializedEncryptionProtectorProperties.serverKeyType
                        = ServerKeyType.fromString(reader.getString());
                } else if ("subregion".equals(fieldName)) {
                    deserializedEncryptionProtectorProperties.subregion = reader.getString();
                } else if ("serverKeyName".equals(fieldName)) {
                    deserializedEncryptionProtectorProperties.serverKeyName = reader.getString();
                } else if ("uri".equals(fieldName)) {
                    deserializedEncryptionProtectorProperties.uri = reader.getString();
                } else if ("thumbprint".equals(fieldName)) {
                    deserializedEncryptionProtectorProperties.thumbprint = reader.getString();
                } else if ("autoRotationEnabled".equals(fieldName)) {
                    deserializedEncryptionProtectorProperties.autoRotationEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEncryptionProtectorProperties;
        });
    }
}
