/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.RestorableDroppedDatabaseProperties;
import com.azure.resourcemanager.sql.models.BackupStorageRedundancy;
import com.azure.resourcemanager.sql.models.Sku;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class RestorableDroppedDatabaseInner
extends ProxyResource {
    private Sku sku;
    private String location;
    private Map<String, String> tags;
    private RestorableDroppedDatabaseProperties innerProperties;
    private String type;
    private String name;
    private String id;

    public Sku sku() {
        return this.sku;
    }

    public RestorableDroppedDatabaseInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public String location() {
        return this.location;
    }

    public RestorableDroppedDatabaseInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public RestorableDroppedDatabaseInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private RestorableDroppedDatabaseProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String databaseName() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseName();
    }

    public Long maxSizeBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().maxSizeBytes();
    }

    public OffsetDateTime creationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().creationDate();
    }

    public OffsetDateTime deletionDate() {
        return this.innerProperties() == null ? null : this.innerProperties().deletionDate();
    }

    public OffsetDateTime earliestRestoreDate() {
        return this.innerProperties() == null ? null : this.innerProperties().earliestRestoreDate();
    }

    public BackupStorageRedundancy backupStorageRedundancy() {
        return this.innerProperties() == null ? null : this.innerProperties().backupStorageRedundancy();
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static RestorableDroppedDatabaseInner fromJson(JsonReader jsonReader) throws IOException {
        return (RestorableDroppedDatabaseInner)((Object)jsonReader.readObject(reader -> {
            RestorableDroppedDatabaseInner deserializedRestorableDroppedDatabaseInner = new RestorableDroppedDatabaseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRestorableDroppedDatabaseInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRestorableDroppedDatabaseInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRestorableDroppedDatabaseInner.type = reader.getString();
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedRestorableDroppedDatabaseInner.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedRestorableDroppedDatabaseInner.location = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedRestorableDroppedDatabaseInner.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRestorableDroppedDatabaseInner.innerProperties = RestorableDroppedDatabaseProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestorableDroppedDatabaseInner;
        }));
    }
}

