/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.SensitivityLabelInner;
import com.azure.resourcemanager.sql.models.SensitivityLabelUpdateKind;
import java.io.IOException;

public final class SensitivityLabelUpdatePropertiesInner
implements JsonSerializable<SensitivityLabelUpdatePropertiesInner> {
    private SensitivityLabelUpdateKind op;
    private String schema;
    private String table;
    private String column;
    private SensitivityLabelInner sensitivityLabel;
    private static final ClientLogger LOGGER = new ClientLogger(SensitivityLabelUpdatePropertiesInner.class);

    public SensitivityLabelUpdateKind op() {
        return this.op;
    }

    public SensitivityLabelUpdatePropertiesInner withOp(SensitivityLabelUpdateKind op) {
        this.op = op;
        return this;
    }

    public String schema() {
        return this.schema;
    }

    public SensitivityLabelUpdatePropertiesInner withSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public String table() {
        return this.table;
    }

    public SensitivityLabelUpdatePropertiesInner withTable(String table) {
        this.table = table;
        return this;
    }

    public String column() {
        return this.column;
    }

    public SensitivityLabelUpdatePropertiesInner withColumn(String column) {
        this.column = column;
        return this;
    }

    public SensitivityLabelInner sensitivityLabel() {
        return this.sensitivityLabel;
    }

    public SensitivityLabelUpdatePropertiesInner withSensitivityLabel(SensitivityLabelInner sensitivityLabel) {
        this.sensitivityLabel = sensitivityLabel;
        return this;
    }

    public void validate() {
        if (this.op() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property op in model SensitivityLabelUpdatePropertiesInner"));
        }
        if (this.schema() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property schema in model SensitivityLabelUpdatePropertiesInner"));
        }
        if (this.table() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property table in model SensitivityLabelUpdatePropertiesInner"));
        }
        if (this.column() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property column in model SensitivityLabelUpdatePropertiesInner"));
        }
        if (this.sensitivityLabel() != null) {
            this.sensitivityLabel().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("op", this.op == null ? null : this.op.toString());
        jsonWriter.writeStringField("schema", this.schema);
        jsonWriter.writeStringField("table", this.table);
        jsonWriter.writeStringField("column", this.column);
        jsonWriter.writeJsonField("sensitivityLabel", (JsonSerializable)this.sensitivityLabel);
        return jsonWriter.writeEndObject();
    }

    public static SensitivityLabelUpdatePropertiesInner fromJson(JsonReader jsonReader) throws IOException {
        return (SensitivityLabelUpdatePropertiesInner)jsonReader.readObject(reader -> {
            SensitivityLabelUpdatePropertiesInner deserializedSensitivityLabelUpdatePropertiesInner = new SensitivityLabelUpdatePropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("op".equals(fieldName)) {
                    deserializedSensitivityLabelUpdatePropertiesInner.op = SensitivityLabelUpdateKind.fromString(reader.getString());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedSensitivityLabelUpdatePropertiesInner.schema = reader.getString();
                    continue;
                }
                if ("table".equals(fieldName)) {
                    deserializedSensitivityLabelUpdatePropertiesInner.table = reader.getString();
                    continue;
                }
                if ("column".equals(fieldName)) {
                    deserializedSensitivityLabelUpdatePropertiesInner.column = reader.getString();
                    continue;
                }
                if ("sensitivityLabel".equals(fieldName)) {
                    deserializedSensitivityLabelUpdatePropertiesInner.sensitivityLabel = SensitivityLabelInner.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSensitivityLabelUpdatePropertiesInner;
        });
    }
}

