// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;

/**
 * Azure Active Directory identity configuration for a resource.
 */
@Fluent
public final class ResourceIdentity implements JsonSerializable<ResourceIdentity> {
    /*
     * The resource ids of the user assigned identities to use
     */
    private Map<String, UserIdentity> userAssignedIdentities;

    /*
     * The Azure Active Directory principal id.
     */
    private UUID principalId;

    /*
     * The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active
     * Directory principal for the resource.
     */
    private IdentityType type;

    /*
     * The Azure Active Directory tenant id.
     */
    private UUID tenantId;

    /**
     * Creates an instance of ResourceIdentity class.
     */
    public ResourceIdentity() {
    }

    /**
     * Get the userAssignedIdentities property: The resource ids of the user assigned identities to use.
     * 
     * @return the userAssignedIdentities value.
     */
    public Map<String, UserIdentity> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    /**
     * Set the userAssignedIdentities property: The resource ids of the user assigned identities to use.
     * 
     * @param userAssignedIdentities the userAssignedIdentities value to set.
     * @return the ResourceIdentity object itself.
     */
    public ResourceIdentity withUserAssignedIdentities(Map<String, UserIdentity> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    /**
     * Get the principalId property: The Azure Active Directory principal id.
     * 
     * @return the principalId value.
     */
    public UUID principalId() {
        return this.principalId;
    }

    /**
     * Get the type property: The identity type. Set this to 'SystemAssigned' in order to automatically create and
     * assign an Azure Active Directory principal for the resource.
     * 
     * @return the type value.
     */
    public IdentityType type() {
        return this.type;
    }

    /**
     * Set the type property: The identity type. Set this to 'SystemAssigned' in order to automatically create and
     * assign an Azure Active Directory principal for the resource.
     * 
     * @param type the type value to set.
     * @return the ResourceIdentity object itself.
     */
    public ResourceIdentity withType(IdentityType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the tenantId property: The Azure Active Directory tenant id.
     * 
     * @return the tenantId value.
     */
    public UUID tenantId() {
        return this.tenantId;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (userAssignedIdentities() != null) {
            userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceIdentity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceIdentity if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceIdentity.
     */
    public static ResourceIdentity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceIdentity deserializedResourceIdentity = new ResourceIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("userAssignedIdentities".equals(fieldName)) {
                    Map<String, UserIdentity> userAssignedIdentities
                        = reader.readMap(reader1 -> UserIdentity.fromJson(reader1));
                    deserializedResourceIdentity.userAssignedIdentities = userAssignedIdentities;
                } else if ("principalId".equals(fieldName)) {
                    deserializedResourceIdentity.principalId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else if ("type".equals(fieldName)) {
                    deserializedResourceIdentity.type = IdentityType.fromString(reader.getString());
                } else if ("tenantId".equals(fieldName)) {
                    deserializedResourceIdentity.tenantId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceIdentity;
        });
    }
}
