// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contains information of estimated or observed impact on various metrics for an Azure SQL Database, Server or Elastic
 * Pool Recommended Action.
 */
@Immutable
public final class RecommendedActionImpactRecord implements JsonSerializable<RecommendedActionImpactRecord> {
    /*
     * Gets the name of the impact dimension. e.g., CPUChange, DiskSpaceChange, NumberOfQueriesAffected.
     */
    private String dimensionName;

    /*
     * Gets the name of the impact dimension. e.g., CPUChange, DiskSpaceChange, NumberOfQueriesAffected.
     */
    private String unit;

    /*
     * Gets the absolute value of this dimension if applicable. e.g., Number of Queries affected
     */
    private Double absoluteValue;

    /*
     * Gets the absolute change in the value of this dimension. e.g., Absolute Disk space change in Megabytes
     */
    private Double changeValueAbsolute;

    /*
     * Gets the relative change in the value of this dimension. e.g., Relative Disk space change in Percentage
     */
    private Double changeValueRelative;

    /**
     * Creates an instance of RecommendedActionImpactRecord class.
     */
    public RecommendedActionImpactRecord() {
    }

    /**
     * Get the dimensionName property: Gets the name of the impact dimension. e.g., CPUChange, DiskSpaceChange,
     * NumberOfQueriesAffected.
     * 
     * @return the dimensionName value.
     */
    public String dimensionName() {
        return this.dimensionName;
    }

    /**
     * Get the unit property: Gets the name of the impact dimension. e.g., CPUChange, DiskSpaceChange,
     * NumberOfQueriesAffected.
     * 
     * @return the unit value.
     */
    public String unit() {
        return this.unit;
    }

    /**
     * Get the absoluteValue property: Gets the absolute value of this dimension if applicable. e.g., Number of Queries
     * affected.
     * 
     * @return the absoluteValue value.
     */
    public Double absoluteValue() {
        return this.absoluteValue;
    }

    /**
     * Get the changeValueAbsolute property: Gets the absolute change in the value of this dimension. e.g., Absolute
     * Disk space change in Megabytes.
     * 
     * @return the changeValueAbsolute value.
     */
    public Double changeValueAbsolute() {
        return this.changeValueAbsolute;
    }

    /**
     * Get the changeValueRelative property: Gets the relative change in the value of this dimension. e.g., Relative
     * Disk space change in Percentage.
     * 
     * @return the changeValueRelative value.
     */
    public Double changeValueRelative() {
        return this.changeValueRelative;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RecommendedActionImpactRecord from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RecommendedActionImpactRecord if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RecommendedActionImpactRecord.
     */
    public static RecommendedActionImpactRecord fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecommendedActionImpactRecord deserializedRecommendedActionImpactRecord
                = new RecommendedActionImpactRecord();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("dimensionName".equals(fieldName)) {
                    deserializedRecommendedActionImpactRecord.dimensionName = reader.getString();
                } else if ("unit".equals(fieldName)) {
                    deserializedRecommendedActionImpactRecord.unit = reader.getString();
                } else if ("absoluteValue".equals(fieldName)) {
                    deserializedRecommendedActionImpactRecord.absoluteValue = reader.getNullable(JsonReader::getDouble);
                } else if ("changeValueAbsolute".equals(fieldName)) {
                    deserializedRecommendedActionImpactRecord.changeValueAbsolute
                        = reader.getNullable(JsonReader::getDouble);
                } else if ("changeValueRelative".equals(fieldName)) {
                    deserializedRecommendedActionImpactRecord.changeValueRelative
                        = reader.getNullable(JsonReader::getDouble);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRecommendedActionImpactRecord;
        });
    }
}
