// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The PrivateLinkServiceConnectionStateProperty model.
 */
@Fluent
public final class PrivateLinkServiceConnectionStateProperty
    implements JsonSerializable<PrivateLinkServiceConnectionStateProperty> {
    /*
     * The private link service connection status.
     */
    private PrivateLinkServiceConnectionStateStatus status;

    /*
     * The private link service connection description.
     */
    private String description;

    /*
     * The actions required for private link service connection.
     */
    private PrivateLinkServiceConnectionStateActionsRequire actionsRequired;

    /**
     * Creates an instance of PrivateLinkServiceConnectionStateProperty class.
     */
    public PrivateLinkServiceConnectionStateProperty() {
    }

    /**
     * Get the status property: The private link service connection status.
     * 
     * @return the status value.
     */
    public PrivateLinkServiceConnectionStateStatus status() {
        return this.status;
    }

    /**
     * Set the status property: The private link service connection status.
     * 
     * @param status the status value to set.
     * @return the PrivateLinkServiceConnectionStateProperty object itself.
     */
    public PrivateLinkServiceConnectionStateProperty withStatus(PrivateLinkServiceConnectionStateStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the description property: The private link service connection description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The private link service connection description.
     * 
     * @param description the description value to set.
     * @return the PrivateLinkServiceConnectionStateProperty object itself.
     */
    public PrivateLinkServiceConnectionStateProperty withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the actionsRequired property: The actions required for private link service connection.
     * 
     * @return the actionsRequired value.
     */
    public PrivateLinkServiceConnectionStateActionsRequire actionsRequired() {
        return this.actionsRequired;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (status() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property status in model PrivateLinkServiceConnectionStateProperty"));
        }
        if (description() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property description in model PrivateLinkServiceConnectionStateProperty"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(PrivateLinkServiceConnectionStateProperty.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PrivateLinkServiceConnectionStateProperty from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PrivateLinkServiceConnectionStateProperty if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PrivateLinkServiceConnectionStateProperty.
     */
    public static PrivateLinkServiceConnectionStateProperty fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PrivateLinkServiceConnectionStateProperty deserializedPrivateLinkServiceConnectionStateProperty
                = new PrivateLinkServiceConnectionStateProperty();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedPrivateLinkServiceConnectionStateProperty.status
                        = PrivateLinkServiceConnectionStateStatus.fromString(reader.getString());
                } else if ("description".equals(fieldName)) {
                    deserializedPrivateLinkServiceConnectionStateProperty.description = reader.getString();
                } else if ("actionsRequired".equals(fieldName)) {
                    deserializedPrivateLinkServiceConnectionStateProperty.actionsRequired
                        = PrivateLinkServiceConnectionStateActionsRequire.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPrivateLinkServiceConnectionStateProperty;
        });
    }
}
