// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Workload group operations for a data warehouse.
 */
@Fluent
public final class WorkloadGroupInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private WorkloadGroupProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of WorkloadGroupInner class.
     */
    public WorkloadGroupInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private WorkloadGroupProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the minResourcePercent property: The workload group minimum percentage resource.
     * 
     * @return the minResourcePercent value.
     */
    public Integer minResourcePercent() {
        return this.innerProperties() == null ? null : this.innerProperties().minResourcePercent();
    }

    /**
     * Set the minResourcePercent property: The workload group minimum percentage resource.
     * 
     * @param minResourcePercent the minResourcePercent value to set.
     * @return the WorkloadGroupInner object itself.
     */
    public WorkloadGroupInner withMinResourcePercent(Integer minResourcePercent) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkloadGroupProperties();
        }
        this.innerProperties().withMinResourcePercent(minResourcePercent);
        return this;
    }

    /**
     * Get the maxResourcePercent property: The workload group cap percentage resource.
     * 
     * @return the maxResourcePercent value.
     */
    public Integer maxResourcePercent() {
        return this.innerProperties() == null ? null : this.innerProperties().maxResourcePercent();
    }

    /**
     * Set the maxResourcePercent property: The workload group cap percentage resource.
     * 
     * @param maxResourcePercent the maxResourcePercent value to set.
     * @return the WorkloadGroupInner object itself.
     */
    public WorkloadGroupInner withMaxResourcePercent(Integer maxResourcePercent) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkloadGroupProperties();
        }
        this.innerProperties().withMaxResourcePercent(maxResourcePercent);
        return this;
    }

    /**
     * Get the minResourcePercentPerRequest property: The workload group request minimum grant percentage.
     * 
     * @return the minResourcePercentPerRequest value.
     */
    public Double minResourcePercentPerRequest() {
        return this.innerProperties() == null ? null : this.innerProperties().minResourcePercentPerRequest();
    }

    /**
     * Set the minResourcePercentPerRequest property: The workload group request minimum grant percentage.
     * 
     * @param minResourcePercentPerRequest the minResourcePercentPerRequest value to set.
     * @return the WorkloadGroupInner object itself.
     */
    public WorkloadGroupInner withMinResourcePercentPerRequest(Double minResourcePercentPerRequest) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkloadGroupProperties();
        }
        this.innerProperties().withMinResourcePercentPerRequest(minResourcePercentPerRequest);
        return this;
    }

    /**
     * Get the maxResourcePercentPerRequest property: The workload group request maximum grant percentage.
     * 
     * @return the maxResourcePercentPerRequest value.
     */
    public Double maxResourcePercentPerRequest() {
        return this.innerProperties() == null ? null : this.innerProperties().maxResourcePercentPerRequest();
    }

    /**
     * Set the maxResourcePercentPerRequest property: The workload group request maximum grant percentage.
     * 
     * @param maxResourcePercentPerRequest the maxResourcePercentPerRequest value to set.
     * @return the WorkloadGroupInner object itself.
     */
    public WorkloadGroupInner withMaxResourcePercentPerRequest(Double maxResourcePercentPerRequest) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkloadGroupProperties();
        }
        this.innerProperties().withMaxResourcePercentPerRequest(maxResourcePercentPerRequest);
        return this;
    }

    /**
     * Get the importance property: The workload group importance level.
     * 
     * @return the importance value.
     */
    public String importance() {
        return this.innerProperties() == null ? null : this.innerProperties().importance();
    }

    /**
     * Set the importance property: The workload group importance level.
     * 
     * @param importance the importance value to set.
     * @return the WorkloadGroupInner object itself.
     */
    public WorkloadGroupInner withImportance(String importance) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkloadGroupProperties();
        }
        this.innerProperties().withImportance(importance);
        return this;
    }

    /**
     * Get the queryExecutionTimeout property: The workload group query execution timeout.
     * 
     * @return the queryExecutionTimeout value.
     */
    public Integer queryExecutionTimeout() {
        return this.innerProperties() == null ? null : this.innerProperties().queryExecutionTimeout();
    }

    /**
     * Set the queryExecutionTimeout property: The workload group query execution timeout.
     * 
     * @param queryExecutionTimeout the queryExecutionTimeout value to set.
     * @return the WorkloadGroupInner object itself.
     */
    public WorkloadGroupInner withQueryExecutionTimeout(Integer queryExecutionTimeout) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkloadGroupProperties();
        }
        this.innerProperties().withQueryExecutionTimeout(queryExecutionTimeout);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkloadGroupInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkloadGroupInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the WorkloadGroupInner.
     */
    public static WorkloadGroupInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkloadGroupInner deserializedWorkloadGroupInner = new WorkloadGroupInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedWorkloadGroupInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedWorkloadGroupInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedWorkloadGroupInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedWorkloadGroupInner.innerProperties = WorkloadGroupProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkloadGroupInner;
        });
    }
}
