/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.AutoPauseDelayTimeRange;
import com.azure.resourcemanager.sql.models.CapabilityStatus;
import com.azure.resourcemanager.sql.models.LicenseTypeCapability;
import com.azure.resourcemanager.sql.models.MaintenanceConfigurationCapability;
import com.azure.resourcemanager.sql.models.MaxSizeCapability;
import com.azure.resourcemanager.sql.models.MaxSizeRangeCapability;
import com.azure.resourcemanager.sql.models.MinCapacityCapability;
import com.azure.resourcemanager.sql.models.PerformanceLevelCapability;
import com.azure.resourcemanager.sql.models.Sku;
import java.io.IOException;
import java.util.List;
import java.util.UUID;

public final class ServiceObjectiveCapability
implements JsonSerializable<ServiceObjectiveCapability> {
    private UUID id;
    private String name;
    private List<MaxSizeRangeCapability> supportedMaxSizes;
    private PerformanceLevelCapability performanceLevel;
    private Sku sku;
    private List<LicenseTypeCapability> supportedLicenseTypes;
    private MaxSizeCapability includedMaxSize;
    private Boolean zoneRedundant;
    private AutoPauseDelayTimeRange supportedAutoPauseDelay;
    private List<MinCapacityCapability> supportedMinCapacities;
    private String computeModel;
    private List<MaintenanceConfigurationCapability> supportedMaintenanceConfigurations;
    private CapabilityStatus status;
    private String reason;

    public UUID id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public List<MaxSizeRangeCapability> supportedMaxSizes() {
        return this.supportedMaxSizes;
    }

    public PerformanceLevelCapability performanceLevel() {
        return this.performanceLevel;
    }

    public Sku sku() {
        return this.sku;
    }

    public List<LicenseTypeCapability> supportedLicenseTypes() {
        return this.supportedLicenseTypes;
    }

    public MaxSizeCapability includedMaxSize() {
        return this.includedMaxSize;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public AutoPauseDelayTimeRange supportedAutoPauseDelay() {
        return this.supportedAutoPauseDelay;
    }

    public List<MinCapacityCapability> supportedMinCapacities() {
        return this.supportedMinCapacities;
    }

    public String computeModel() {
        return this.computeModel;
    }

    public List<MaintenanceConfigurationCapability> supportedMaintenanceConfigurations() {
        return this.supportedMaintenanceConfigurations;
    }

    public CapabilityStatus status() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public ServiceObjectiveCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    public void validate() {
        if (this.supportedMaxSizes() != null) {
            this.supportedMaxSizes().forEach(e -> e.validate());
        }
        if (this.performanceLevel() != null) {
            this.performanceLevel().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.supportedLicenseTypes() != null) {
            this.supportedLicenseTypes().forEach(e -> e.validate());
        }
        if (this.includedMaxSize() != null) {
            this.includedMaxSize().validate();
        }
        if (this.supportedAutoPauseDelay() != null) {
            this.supportedAutoPauseDelay().validate();
        }
        if (this.supportedMinCapacities() != null) {
            this.supportedMinCapacities().forEach(e -> e.validate());
        }
        if (this.supportedMaintenanceConfigurations() != null) {
            this.supportedMaintenanceConfigurations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    public static ServiceObjectiveCapability fromJson(JsonReader jsonReader) throws IOException {
        return (ServiceObjectiveCapability)jsonReader.readObject(reader -> {
            ServiceObjectiveCapability deserializedServiceObjectiveCapability = new ServiceObjectiveCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedServiceObjectiveCapability.id = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedServiceObjectiveCapability.name = reader.getString();
                    continue;
                }
                if ("supportedMaxSizes".equals(fieldName)) {
                    List supportedMaxSizes;
                    deserializedServiceObjectiveCapability.supportedMaxSizes = supportedMaxSizes = reader.readArray(reader1 -> MaxSizeRangeCapability.fromJson(reader1));
                    continue;
                }
                if ("performanceLevel".equals(fieldName)) {
                    deserializedServiceObjectiveCapability.performanceLevel = PerformanceLevelCapability.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedServiceObjectiveCapability.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("supportedLicenseTypes".equals(fieldName)) {
                    List supportedLicenseTypes;
                    deserializedServiceObjectiveCapability.supportedLicenseTypes = supportedLicenseTypes = reader.readArray(reader1 -> LicenseTypeCapability.fromJson(reader1));
                    continue;
                }
                if ("includedMaxSize".equals(fieldName)) {
                    deserializedServiceObjectiveCapability.includedMaxSize = MaxSizeCapability.fromJson(reader);
                    continue;
                }
                if ("zoneRedundant".equals(fieldName)) {
                    deserializedServiceObjectiveCapability.zoneRedundant = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("supportedAutoPauseDelay".equals(fieldName)) {
                    deserializedServiceObjectiveCapability.supportedAutoPauseDelay = AutoPauseDelayTimeRange.fromJson(reader);
                    continue;
                }
                if ("supportedMinCapacities".equals(fieldName)) {
                    List supportedMinCapacities;
                    deserializedServiceObjectiveCapability.supportedMinCapacities = supportedMinCapacities = reader.readArray(reader1 -> MinCapacityCapability.fromJson(reader1));
                    continue;
                }
                if ("computeModel".equals(fieldName)) {
                    deserializedServiceObjectiveCapability.computeModel = reader.getString();
                    continue;
                }
                if ("supportedMaintenanceConfigurations".equals(fieldName)) {
                    List supportedMaintenanceConfigurations;
                    deserializedServiceObjectiveCapability.supportedMaintenanceConfigurations = supportedMaintenanceConfigurations = reader.readArray(reader1 -> MaintenanceConfigurationCapability.fromJson(reader1));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedServiceObjectiveCapability.status = CapabilityStatus.fromString(reader.getString());
                    continue;
                }
                if ("reason".equals(fieldName)) {
                    deserializedServiceObjectiveCapability.reason = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServiceObjectiveCapability;
        });
    }
}

