/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.JobTarget;
import java.io.IOException;
import java.util.List;

public final class JobTargetGroupProperties
implements JsonSerializable<JobTargetGroupProperties> {
    private List<JobTarget> members;
    private static final ClientLogger LOGGER = new ClientLogger(JobTargetGroupProperties.class);

    public List<JobTarget> members() {
        return this.members;
    }

    public JobTargetGroupProperties withMembers(List<JobTarget> members) {
        this.members = members;
        return this;
    }

    public void validate() {
        if (this.members() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property members in model JobTargetGroupProperties"));
        }
        this.members().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("members", this.members, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static JobTargetGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return (JobTargetGroupProperties)jsonReader.readObject(reader -> {
            JobTargetGroupProperties deserializedJobTargetGroupProperties = new JobTargetGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("members".equals(fieldName)) {
                    List members;
                    deserializedJobTargetGroupProperties.members = members = reader.readArray(reader1 -> JobTarget.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobTargetGroupProperties;
        });
    }
}

