/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.BlobAuditingPolicyState;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public final class ExtendedDatabaseBlobAuditingPolicyProperties
implements JsonSerializable<ExtendedDatabaseBlobAuditingPolicyProperties> {
    private String predicateExpression;
    private Integer retentionDays;
    private List<String> auditActionsAndGroups;
    private Boolean isStorageSecondaryKeyInUse;
    private Boolean isAzureMonitorTargetEnabled;
    private Integer queueDelayMs;
    private Boolean isManagedIdentityInUse;
    private BlobAuditingPolicyState state;
    private String storageEndpoint;
    private String storageAccountAccessKey;
    private UUID storageAccountSubscriptionId;
    private static final ClientLogger LOGGER = new ClientLogger(ExtendedDatabaseBlobAuditingPolicyProperties.class);

    public String predicateExpression() {
        return this.predicateExpression;
    }

    public ExtendedDatabaseBlobAuditingPolicyProperties withPredicateExpression(String predicateExpression) {
        this.predicateExpression = predicateExpression;
        return this;
    }

    public Integer retentionDays() {
        return this.retentionDays;
    }

    public ExtendedDatabaseBlobAuditingPolicyProperties withRetentionDays(Integer retentionDays) {
        this.retentionDays = retentionDays;
        return this;
    }

    public List<String> auditActionsAndGroups() {
        return this.auditActionsAndGroups;
    }

    public ExtendedDatabaseBlobAuditingPolicyProperties withAuditActionsAndGroups(List<String> auditActionsAndGroups) {
        this.auditActionsAndGroups = auditActionsAndGroups;
        return this;
    }

    public Boolean isStorageSecondaryKeyInUse() {
        return this.isStorageSecondaryKeyInUse;
    }

    public ExtendedDatabaseBlobAuditingPolicyProperties withIsStorageSecondaryKeyInUse(Boolean isStorageSecondaryKeyInUse) {
        this.isStorageSecondaryKeyInUse = isStorageSecondaryKeyInUse;
        return this;
    }

    public Boolean isAzureMonitorTargetEnabled() {
        return this.isAzureMonitorTargetEnabled;
    }

    public ExtendedDatabaseBlobAuditingPolicyProperties withIsAzureMonitorTargetEnabled(Boolean isAzureMonitorTargetEnabled) {
        this.isAzureMonitorTargetEnabled = isAzureMonitorTargetEnabled;
        return this;
    }

    public Integer queueDelayMs() {
        return this.queueDelayMs;
    }

    public ExtendedDatabaseBlobAuditingPolicyProperties withQueueDelayMs(Integer queueDelayMs) {
        this.queueDelayMs = queueDelayMs;
        return this;
    }

    public Boolean isManagedIdentityInUse() {
        return this.isManagedIdentityInUse;
    }

    public ExtendedDatabaseBlobAuditingPolicyProperties withIsManagedIdentityInUse(Boolean isManagedIdentityInUse) {
        this.isManagedIdentityInUse = isManagedIdentityInUse;
        return this;
    }

    public BlobAuditingPolicyState state() {
        return this.state;
    }

    public ExtendedDatabaseBlobAuditingPolicyProperties withState(BlobAuditingPolicyState state) {
        this.state = state;
        return this;
    }

    public String storageEndpoint() {
        return this.storageEndpoint;
    }

    public ExtendedDatabaseBlobAuditingPolicyProperties withStorageEndpoint(String storageEndpoint) {
        this.storageEndpoint = storageEndpoint;
        return this;
    }

    public String storageAccountAccessKey() {
        return this.storageAccountAccessKey;
    }

    public ExtendedDatabaseBlobAuditingPolicyProperties withStorageAccountAccessKey(String storageAccountAccessKey) {
        this.storageAccountAccessKey = storageAccountAccessKey;
        return this;
    }

    public UUID storageAccountSubscriptionId() {
        return this.storageAccountSubscriptionId;
    }

    public ExtendedDatabaseBlobAuditingPolicyProperties withStorageAccountSubscriptionId(UUID storageAccountSubscriptionId) {
        this.storageAccountSubscriptionId = storageAccountSubscriptionId;
        return this;
    }

    public void validate() {
        if (this.state() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property state in model ExtendedDatabaseBlobAuditingPolicyProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("predicateExpression", this.predicateExpression);
        jsonWriter.writeNumberField("retentionDays", (Number)this.retentionDays);
        jsonWriter.writeArrayField("auditActionsAndGroups", this.auditActionsAndGroups, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("isStorageSecondaryKeyInUse", this.isStorageSecondaryKeyInUse);
        jsonWriter.writeBooleanField("isAzureMonitorTargetEnabled", this.isAzureMonitorTargetEnabled);
        jsonWriter.writeNumberField("queueDelayMs", (Number)this.queueDelayMs);
        jsonWriter.writeBooleanField("isManagedIdentityInUse", this.isManagedIdentityInUse);
        jsonWriter.writeStringField("storageEndpoint", this.storageEndpoint);
        jsonWriter.writeStringField("storageAccountAccessKey", this.storageAccountAccessKey);
        jsonWriter.writeStringField("storageAccountSubscriptionId", Objects.toString(this.storageAccountSubscriptionId, null));
        return jsonWriter.writeEndObject();
    }

    public static ExtendedDatabaseBlobAuditingPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ExtendedDatabaseBlobAuditingPolicyProperties)jsonReader.readObject(reader -> {
            ExtendedDatabaseBlobAuditingPolicyProperties deserializedExtendedDatabaseBlobAuditingPolicyProperties = new ExtendedDatabaseBlobAuditingPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedExtendedDatabaseBlobAuditingPolicyProperties.state = BlobAuditingPolicyState.fromString(reader.getString());
                    continue;
                }
                if ("predicateExpression".equals(fieldName)) {
                    deserializedExtendedDatabaseBlobAuditingPolicyProperties.predicateExpression = reader.getString();
                    continue;
                }
                if ("retentionDays".equals(fieldName)) {
                    deserializedExtendedDatabaseBlobAuditingPolicyProperties.retentionDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("auditActionsAndGroups".equals(fieldName)) {
                    List auditActionsAndGroups;
                    deserializedExtendedDatabaseBlobAuditingPolicyProperties.auditActionsAndGroups = auditActionsAndGroups = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("isStorageSecondaryKeyInUse".equals(fieldName)) {
                    deserializedExtendedDatabaseBlobAuditingPolicyProperties.isStorageSecondaryKeyInUse = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isAzureMonitorTargetEnabled".equals(fieldName)) {
                    deserializedExtendedDatabaseBlobAuditingPolicyProperties.isAzureMonitorTargetEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("queueDelayMs".equals(fieldName)) {
                    deserializedExtendedDatabaseBlobAuditingPolicyProperties.queueDelayMs = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("isManagedIdentityInUse".equals(fieldName)) {
                    deserializedExtendedDatabaseBlobAuditingPolicyProperties.isManagedIdentityInUse = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("storageEndpoint".equals(fieldName)) {
                    deserializedExtendedDatabaseBlobAuditingPolicyProperties.storageEndpoint = reader.getString();
                    continue;
                }
                if ("storageAccountAccessKey".equals(fieldName)) {
                    deserializedExtendedDatabaseBlobAuditingPolicyProperties.storageAccountAccessKey = reader.getString();
                    continue;
                }
                if ("storageAccountSubscriptionId".equals(fieldName)) {
                    deserializedExtendedDatabaseBlobAuditingPolicyProperties.storageAccountSubscriptionId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExtendedDatabaseBlobAuditingPolicyProperties;
        });
    }
}

