// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of a topquery metric in one interval.
 */
@Immutable
public final class QueryMetricProperties implements JsonSerializable<QueryMetricProperties> {
    /*
     * The name information for the metric.
     */
    private String name;

    /*
     * The UI appropriate name for the metric.
     */
    private String displayName;

    /*
     * The unit of the metric.
     */
    private QueryMetricUnitType unit;

    /*
     * The value of the metric.
     */
    private Double value;

    /*
     * Metric value when min() aggregate function is used over the interval.
     */
    private Double min;

    /*
     * Metric value when max() aggregate function is used over the interval.
     */
    private Double max;

    /*
     * Metric value when avg() aggregate function is used over the interval.
     */
    private Double avg;

    /*
     * Metric value when sum() aggregate function is used over the interval.
     */
    private Double sum;

    /*
     * Metric value when stdev aggregate function is used over the interval.
     */
    private Double stdev;

    /**
     * Creates an instance of QueryMetricProperties class.
     */
    public QueryMetricProperties() {
    }

    /**
     * Get the name property: The name information for the metric.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the displayName property: The UI appropriate name for the metric.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Get the unit property: The unit of the metric.
     * 
     * @return the unit value.
     */
    public QueryMetricUnitType unit() {
        return this.unit;
    }

    /**
     * Get the value property: The value of the metric.
     * 
     * @return the value value.
     */
    public Double value() {
        return this.value;
    }

    /**
     * Get the min property: Metric value when min() aggregate function is used over the interval.
     * 
     * @return the min value.
     */
    public Double min() {
        return this.min;
    }

    /**
     * Get the max property: Metric value when max() aggregate function is used over the interval.
     * 
     * @return the max value.
     */
    public Double max() {
        return this.max;
    }

    /**
     * Get the avg property: Metric value when avg() aggregate function is used over the interval.
     * 
     * @return the avg value.
     */
    public Double avg() {
        return this.avg;
    }

    /**
     * Get the sum property: Metric value when sum() aggregate function is used over the interval.
     * 
     * @return the sum value.
     */
    public Double sum() {
        return this.sum;
    }

    /**
     * Get the stdev property: Metric value when stdev aggregate function is used over the interval.
     * 
     * @return the stdev value.
     */
    public Double stdev() {
        return this.stdev;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of QueryMetricProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of QueryMetricProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the QueryMetricProperties.
     */
    public static QueryMetricProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            QueryMetricProperties deserializedQueryMetricProperties = new QueryMetricProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedQueryMetricProperties.name = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedQueryMetricProperties.displayName = reader.getString();
                } else if ("unit".equals(fieldName)) {
                    deserializedQueryMetricProperties.unit = QueryMetricUnitType.fromString(reader.getString());
                } else if ("value".equals(fieldName)) {
                    deserializedQueryMetricProperties.value = reader.getNullable(JsonReader::getDouble);
                } else if ("min".equals(fieldName)) {
                    deserializedQueryMetricProperties.min = reader.getNullable(JsonReader::getDouble);
                } else if ("max".equals(fieldName)) {
                    deserializedQueryMetricProperties.max = reader.getNullable(JsonReader::getDouble);
                } else if ("avg".equals(fieldName)) {
                    deserializedQueryMetricProperties.avg = reader.getNullable(JsonReader::getDouble);
                } else if ("sum".equals(fieldName)) {
                    deserializedQueryMetricProperties.sum = reader.getNullable(JsonReader::getDouble);
                } else if ("stdev".equals(fieldName)) {
                    deserializedQueryMetricProperties.stdev = reader.getNullable(JsonReader::getDouble);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedQueryMetricProperties;
        });
    }
}
