// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Partner server information for the failover group.
 */
@Fluent
public final class PartnerInfo implements JsonSerializable<PartnerInfo> {
    /*
     * Resource identifier of the partner server.
     */
    private String id;

    /*
     * Geo location of the partner server.
     */
    private String location;

    /*
     * Replication role of the partner server.
     */
    private FailoverGroupReplicationRole replicationRole;

    /**
     * Creates an instance of PartnerInfo class.
     */
    public PartnerInfo() {
    }

    /**
     * Get the id property: Resource identifier of the partner server.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource identifier of the partner server.
     * 
     * @param id the id value to set.
     * @return the PartnerInfo object itself.
     */
    public PartnerInfo withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the location property: Geo location of the partner server.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the replicationRole property: Replication role of the partner server.
     * 
     * @return the replicationRole value.
     */
    public FailoverGroupReplicationRole replicationRole() {
        return this.replicationRole;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (id() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property id in model PartnerInfo"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(PartnerInfo.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PartnerInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PartnerInfo if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PartnerInfo.
     */
    public static PartnerInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PartnerInfo deserializedPartnerInfo = new PartnerInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedPartnerInfo.id = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedPartnerInfo.location = reader.getString();
                } else if ("replicationRole".equals(fieldName)) {
                    deserializedPartnerInfo.replicationRole
                        = FailoverGroupReplicationRole.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPartnerInfo;
        });
    }
}
