// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.FailoverGroupReadOnlyEndpoint;
import com.azure.resourcemanager.sql.models.FailoverGroupReadWriteEndpoint;
import com.azure.resourcemanager.sql.models.FailoverGroupReplicationRole;
import com.azure.resourcemanager.sql.models.PartnerInfo;
import java.io.IOException;
import java.util.List;

/**
 * Properties of a failover group.
 */
@Fluent
public final class FailoverGroupProperties implements JsonSerializable<FailoverGroupProperties> {
    /*
     * Read-write endpoint of the failover group instance.
     */
    private FailoverGroupReadWriteEndpoint readWriteEndpoint;

    /*
     * Read-only endpoint of the failover group instance.
     */
    private FailoverGroupReadOnlyEndpoint readOnlyEndpoint;

    /*
     * Local replication role of the failover group instance.
     */
    private FailoverGroupReplicationRole replicationRole;

    /*
     * Replication state of the failover group instance.
     */
    private String replicationState;

    /*
     * List of partner server information for the failover group.
     */
    private List<PartnerInfo> partnerServers;

    /*
     * List of databases in the failover group.
     */
    private List<String> databases;

    /**
     * Creates an instance of FailoverGroupProperties class.
     */
    public FailoverGroupProperties() {
    }

    /**
     * Get the readWriteEndpoint property: Read-write endpoint of the failover group instance.
     * 
     * @return the readWriteEndpoint value.
     */
    public FailoverGroupReadWriteEndpoint readWriteEndpoint() {
        return this.readWriteEndpoint;
    }

    /**
     * Set the readWriteEndpoint property: Read-write endpoint of the failover group instance.
     * 
     * @param readWriteEndpoint the readWriteEndpoint value to set.
     * @return the FailoverGroupProperties object itself.
     */
    public FailoverGroupProperties withReadWriteEndpoint(FailoverGroupReadWriteEndpoint readWriteEndpoint) {
        this.readWriteEndpoint = readWriteEndpoint;
        return this;
    }

    /**
     * Get the readOnlyEndpoint property: Read-only endpoint of the failover group instance.
     * 
     * @return the readOnlyEndpoint value.
     */
    public FailoverGroupReadOnlyEndpoint readOnlyEndpoint() {
        return this.readOnlyEndpoint;
    }

    /**
     * Set the readOnlyEndpoint property: Read-only endpoint of the failover group instance.
     * 
     * @param readOnlyEndpoint the readOnlyEndpoint value to set.
     * @return the FailoverGroupProperties object itself.
     */
    public FailoverGroupProperties withReadOnlyEndpoint(FailoverGroupReadOnlyEndpoint readOnlyEndpoint) {
        this.readOnlyEndpoint = readOnlyEndpoint;
        return this;
    }

    /**
     * Get the replicationRole property: Local replication role of the failover group instance.
     * 
     * @return the replicationRole value.
     */
    public FailoverGroupReplicationRole replicationRole() {
        return this.replicationRole;
    }

    /**
     * Get the replicationState property: Replication state of the failover group instance.
     * 
     * @return the replicationState value.
     */
    public String replicationState() {
        return this.replicationState;
    }

    /**
     * Get the partnerServers property: List of partner server information for the failover group.
     * 
     * @return the partnerServers value.
     */
    public List<PartnerInfo> partnerServers() {
        return this.partnerServers;
    }

    /**
     * Set the partnerServers property: List of partner server information for the failover group.
     * 
     * @param partnerServers the partnerServers value to set.
     * @return the FailoverGroupProperties object itself.
     */
    public FailoverGroupProperties withPartnerServers(List<PartnerInfo> partnerServers) {
        this.partnerServers = partnerServers;
        return this;
    }

    /**
     * Get the databases property: List of databases in the failover group.
     * 
     * @return the databases value.
     */
    public List<String> databases() {
        return this.databases;
    }

    /**
     * Set the databases property: List of databases in the failover group.
     * 
     * @param databases the databases value to set.
     * @return the FailoverGroupProperties object itself.
     */
    public FailoverGroupProperties withDatabases(List<String> databases) {
        this.databases = databases;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (readWriteEndpoint() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property readWriteEndpoint in model FailoverGroupProperties"));
        } else {
            readWriteEndpoint().validate();
        }
        if (readOnlyEndpoint() != null) {
            readOnlyEndpoint().validate();
        }
        if (partnerServers() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property partnerServers in model FailoverGroupProperties"));
        } else {
            partnerServers().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(FailoverGroupProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("readWriteEndpoint", this.readWriteEndpoint);
        jsonWriter.writeArrayField("partnerServers", this.partnerServers,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("readOnlyEndpoint", this.readOnlyEndpoint);
        jsonWriter.writeArrayField("databases", this.databases, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FailoverGroupProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FailoverGroupProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the FailoverGroupProperties.
     */
    public static FailoverGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FailoverGroupProperties deserializedFailoverGroupProperties = new FailoverGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("readWriteEndpoint".equals(fieldName)) {
                    deserializedFailoverGroupProperties.readWriteEndpoint
                        = FailoverGroupReadWriteEndpoint.fromJson(reader);
                } else if ("partnerServers".equals(fieldName)) {
                    List<PartnerInfo> partnerServers = reader.readArray(reader1 -> PartnerInfo.fromJson(reader1));
                    deserializedFailoverGroupProperties.partnerServers = partnerServers;
                } else if ("readOnlyEndpoint".equals(fieldName)) {
                    deserializedFailoverGroupProperties.readOnlyEndpoint
                        = FailoverGroupReadOnlyEndpoint.fromJson(reader);
                } else if ("replicationRole".equals(fieldName)) {
                    deserializedFailoverGroupProperties.replicationRole
                        = FailoverGroupReplicationRole.fromString(reader.getString());
                } else if ("replicationState".equals(fieldName)) {
                    deserializedFailoverGroupProperties.replicationState = reader.getString();
                } else if ("databases".equals(fieldName)) {
                    List<String> databases = reader.readArray(reader1 -> reader1.getString());
                    deserializedFailoverGroupProperties.databases = databases;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFailoverGroupProperties;
        });
    }
}
