// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.sql.fluent.models.UpdateLongTermRetentionBackupParametersProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Contains the information necessary to perform long term retention backup update operation. */
@Fluent
public final class UpdateLongTermRetentionBackupParameters {
    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private UpdateLongTermRetentionBackupParametersProperties innerProperties;

    /** Creates an instance of UpdateLongTermRetentionBackupParameters class. */
    public UpdateLongTermRetentionBackupParameters() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private UpdateLongTermRetentionBackupParametersProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the requestedBackupStorageRedundancy property: The storage redundancy type of the copied backup.
     *
     * @return the requestedBackupStorageRedundancy value.
     */
    public BackupStorageRedundancy requestedBackupStorageRedundancy() {
        return this.innerProperties() == null ? null : this.innerProperties().requestedBackupStorageRedundancy();
    }

    /**
     * Set the requestedBackupStorageRedundancy property: The storage redundancy type of the copied backup.
     *
     * @param requestedBackupStorageRedundancy the requestedBackupStorageRedundancy value to set.
     * @return the UpdateLongTermRetentionBackupParameters object itself.
     */
    public UpdateLongTermRetentionBackupParameters withRequestedBackupStorageRedundancy(
        BackupStorageRedundancy requestedBackupStorageRedundancy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UpdateLongTermRetentionBackupParametersProperties();
        }
        this.innerProperties().withRequestedBackupStorageRedundancy(requestedBackupStorageRedundancy);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
