// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The parameters of a managed instance operation. */
@Immutable
public final class ManagedInstanceOperationParametersPair {
    /*
     * The current parameters.
     */
    @JsonProperty(value = "currentParameters", access = JsonProperty.Access.WRITE_ONLY)
    private UpsertManagedServerOperationParameters currentParameters;

    /*
     * The requested parameters.
     */
    @JsonProperty(value = "requestedParameters", access = JsonProperty.Access.WRITE_ONLY)
    private UpsertManagedServerOperationParameters requestedParameters;

    /** Creates an instance of ManagedInstanceOperationParametersPair class. */
    public ManagedInstanceOperationParametersPair() {
    }

    /**
     * Get the currentParameters property: The current parameters.
     *
     * @return the currentParameters value.
     */
    public UpsertManagedServerOperationParameters currentParameters() {
        return this.currentParameters;
    }

    /**
     * Get the requestedParameters property: The requested parameters.
     *
     * @return the requestedParameters value.
     */
    public UpsertManagedServerOperationParameters requestedParameters() {
        return this.requestedParameters;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (currentParameters() != null) {
            currentParameters().validate();
        }
        if (requestedParameters() != null) {
            requestedParameters().validate();
        }
    }
}
