// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.sql.models.DnsRefreshConfigurationPropertiesStatus;
import com.fasterxml.jackson.annotation.JsonProperty;

/** A recoverable managed database resource. */
@Immutable
public final class UpdateManagedInstanceDnsServersOperationInner extends ProxyResource {
    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private DnsRefreshConfigurationProperties innerProperties;

    /** Creates an instance of UpdateManagedInstanceDnsServersOperationInner class. */
    public UpdateManagedInstanceDnsServersOperationInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private DnsRefreshConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the status property: The status of the DNS refresh operation.
     *
     * @return the status value.
     */
    public DnsRefreshConfigurationPropertiesStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
