// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The properties of a time zone. */
@Immutable
public final class TimeZoneProperties {
    /*
     * The time zone id
     */
    @JsonProperty(value = "timeZoneId", access = JsonProperty.Access.WRITE_ONLY)
    private String timeZoneId;

    /*
     * The time zone display name
     */
    @JsonProperty(value = "displayName", access = JsonProperty.Access.WRITE_ONLY)
    private String displayName;

    /** Creates an instance of TimeZoneProperties class. */
    public TimeZoneProperties() {
    }

    /**
     * Get the timeZoneId property: The time zone id.
     *
     * @return the timeZoneId value.
     */
    public String timeZoneId() {
        return this.timeZoneId;
    }

    /**
     * Get the displayName property: The time zone display name.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
