// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.sql.models.SecurityEventSqlInjectionAdditionalProperties;
import com.azure.resourcemanager.sql.models.SecurityEventType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** The properties of a security event. */
@Immutable
public final class SecurityEventProperties {
    /*
     * The time when the security event occurred.
     */
    @JsonProperty(value = "eventTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime eventTime;

    /*
     * The type of the security event.
     */
    @JsonProperty(value = "securityEventType", access = JsonProperty.Access.WRITE_ONLY)
    private SecurityEventType securityEventType;

    /*
     * The subscription name
     */
    @JsonProperty(value = "subscription", access = JsonProperty.Access.WRITE_ONLY)
    private String subscription;

    /*
     * The server name
     */
    @JsonProperty(value = "server", access = JsonProperty.Access.WRITE_ONLY)
    private String server;

    /*
     * The database name
     */
    @JsonProperty(value = "database", access = JsonProperty.Access.WRITE_ONLY)
    private String database;

    /*
     * The IP address of the client who executed the statement.
     */
    @JsonProperty(value = "clientIp", access = JsonProperty.Access.WRITE_ONLY)
    private String clientIp;

    /*
     * The application used to execute the statement.
     */
    @JsonProperty(value = "applicationName", access = JsonProperty.Access.WRITE_ONLY)
    private String applicationName;

    /*
     * The principal user who executed the statement
     */
    @JsonProperty(value = "principalName", access = JsonProperty.Access.WRITE_ONLY)
    private String principalName;

    /*
     * The sql injection additional properties, populated only if the type of the security event is sql injection.
     */
    @JsonProperty(value = "securityEventSqlInjectionAdditionalProperties", access = JsonProperty.Access.WRITE_ONLY)
    private SecurityEventSqlInjectionAdditionalProperties securityEventSqlInjectionAdditionalProperties;

    /** Creates an instance of SecurityEventProperties class. */
    public SecurityEventProperties() {
    }

    /**
     * Get the eventTime property: The time when the security event occurred.
     *
     * @return the eventTime value.
     */
    public OffsetDateTime eventTime() {
        return this.eventTime;
    }

    /**
     * Get the securityEventType property: The type of the security event.
     *
     * @return the securityEventType value.
     */
    public SecurityEventType securityEventType() {
        return this.securityEventType;
    }

    /**
     * Get the subscription property: The subscription name.
     *
     * @return the subscription value.
     */
    public String subscription() {
        return this.subscription;
    }

    /**
     * Get the server property: The server name.
     *
     * @return the server value.
     */
    public String server() {
        return this.server;
    }

    /**
     * Get the database property: The database name.
     *
     * @return the database value.
     */
    public String database() {
        return this.database;
    }

    /**
     * Get the clientIp property: The IP address of the client who executed the statement.
     *
     * @return the clientIp value.
     */
    public String clientIp() {
        return this.clientIp;
    }

    /**
     * Get the applicationName property: The application used to execute the statement.
     *
     * @return the applicationName value.
     */
    public String applicationName() {
        return this.applicationName;
    }

    /**
     * Get the principalName property: The principal user who executed the statement.
     *
     * @return the principalName value.
     */
    public String principalName() {
        return this.principalName;
    }

    /**
     * Get the securityEventSqlInjectionAdditionalProperties property: The sql injection additional properties,
     * populated only if the type of the security event is sql injection.
     *
     * @return the securityEventSqlInjectionAdditionalProperties value.
     */
    public SecurityEventSqlInjectionAdditionalProperties securityEventSqlInjectionAdditionalProperties() {
        return this.securityEventSqlInjectionAdditionalProperties;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (securityEventSqlInjectionAdditionalProperties() != null) {
            securityEventSqlInjectionAdditionalProperties().validate();
        }
    }
}
