// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.fasterxml.jackson.annotation.JsonProperty;

/** A recoverable managed database resource. */
@Immutable
public final class RecoverableManagedDatabaseInner extends ProxyResource {
    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private RecoverableManagedDatabaseProperties innerProperties;

    /** Creates an instance of RecoverableManagedDatabaseInner class. */
    public RecoverableManagedDatabaseInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private RecoverableManagedDatabaseProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the lastAvailableBackupDate property: The last available backup date.
     *
     * @return the lastAvailableBackupDate value.
     */
    public String lastAvailableBackupDate() {
        return this.innerProperties() == null ? null : this.innerProperties().lastAvailableBackupDate();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
