// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.sql.models.BackupStorageRedundancy;
import com.azure.resourcemanager.sql.models.ManagedInstanceExternalAdministrator;
import com.azure.resourcemanager.sql.models.ManagedInstanceLicenseType;
import com.azure.resourcemanager.sql.models.ManagedInstancePecProperty;
import com.azure.resourcemanager.sql.models.ManagedInstancePropertiesProvisioningState;
import com.azure.resourcemanager.sql.models.ManagedInstanceProxyOverride;
import com.azure.resourcemanager.sql.models.ManagedServerCreateMode;
import com.azure.resourcemanager.sql.models.ServicePrincipal;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** The properties of a managed instance. */
@Fluent
public final class ManagedInstanceProperties {
    /*
     * The provisioningState property.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ManagedInstancePropertiesProvisioningState provisioningState;

    /*
     * Specifies the mode of database creation.
     *
     * Default: Regular instance creation.
     *
     * Restore: Creates an instance by restoring a set of backups to specific point in time. RestorePointInTime and
     * SourceManagedInstanceId must be specified.
     */
    @JsonProperty(value = "managedInstanceCreateMode")
    private ManagedServerCreateMode managedInstanceCreateMode;

    /*
     * The fully qualified domain name of the managed instance.
     */
    @JsonProperty(value = "fullyQualifiedDomainName", access = JsonProperty.Access.WRITE_ONLY)
    private String fullyQualifiedDomainName;

    /*
     * Administrator username for the managed instance. Can only be specified when the managed instance is being
     * created (and is required for creation).
     */
    @JsonProperty(value = "administratorLogin")
    private String administratorLogin;

    /*
     * The administrator login password (required for managed instance creation).
     */
    @JsonProperty(value = "administratorLoginPassword")
    private String administratorLoginPassword;

    /*
     * Subnet resource ID for the managed instance.
     */
    @JsonProperty(value = "subnetId")
    private String subnetId;

    /*
     * The state of the managed instance.
     */
    @JsonProperty(value = "state", access = JsonProperty.Access.WRITE_ONLY)
    private String state;

    /*
     * The license type. Possible values are 'LicenseIncluded' (regular price inclusive of a new SQL license) and
     * 'BasePrice' (discounted AHB price for bringing your own SQL licenses).
     */
    @JsonProperty(value = "licenseType")
    private ManagedInstanceLicenseType licenseType;

    /*
     * The number of vCores. Allowed values: 8, 16, 24, 32, 40, 64, 80.
     */
    @JsonProperty(value = "vCores")
    private Integer vCores;

    /*
     * Storage size in GB. Minimum value: 32. Maximum value: 16384. Increments of 32 GB allowed only. Maximum value
     * depends on the selected hardware family and number of vCores.
     */
    @JsonProperty(value = "storageSizeInGB")
    private Integer storageSizeInGB;

    /*
     * Collation of the managed instance.
     */
    @JsonProperty(value = "collation")
    private String collation;

    /*
     * The Dns Zone that the managed instance is in.
     */
    @JsonProperty(value = "dnsZone", access = JsonProperty.Access.WRITE_ONLY)
    private String dnsZone;

    /*
     * The resource id of another managed instance whose DNS zone this managed instance will share after creation.
     */
    @JsonProperty(value = "dnsZonePartner")
    private String dnsZonePartner;

    /*
     * Whether or not the public data endpoint is enabled.
     */
    @JsonProperty(value = "publicDataEndpointEnabled")
    private Boolean publicDataEndpointEnabled;

    /*
     * The resource identifier of the source managed instance associated with create operation of this instance.
     */
    @JsonProperty(value = "sourceManagedInstanceId")
    private String sourceManagedInstanceId;

    /*
     * Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new
     * database.
     */
    @JsonProperty(value = "restorePointInTime")
    private OffsetDateTime restorePointInTime;

    /*
     * Connection type used for connecting to the instance.
     */
    @JsonProperty(value = "proxyOverride")
    private ManagedInstanceProxyOverride proxyOverride;

    /*
     * Id of the timezone. Allowed values are timezones supported by Windows.
     * Windows keeps details on supported timezones, including the id, in registry under
     * KEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones.
     * You can get those registry values via SQL Server by querying SELECT name AS timezone_id FROM sys.time_zone_info.
     * List of Ids can also be obtained by executing [System.TimeZoneInfo]::GetSystemTimeZones() in PowerShell.
     * An example of valid timezone id is "Pacific Standard Time" or "W. Europe Standard Time".
     */
    @JsonProperty(value = "timezoneId")
    private String timezoneId;

    /*
     * The Id of the instance pool this managed server belongs to.
     */
    @JsonProperty(value = "instancePoolId")
    private String instancePoolId;

    /*
     * Specifies maintenance configuration id to apply to this managed instance.
     */
    @JsonProperty(value = "maintenanceConfigurationId")
    private String maintenanceConfigurationId;

    /*
     * List of private endpoint connections on a managed instance.
     */
    @JsonProperty(value = "privateEndpointConnections", access = JsonProperty.Access.WRITE_ONLY)
    private List<ManagedInstancePecProperty> privateEndpointConnections;

    /*
     * Minimal TLS version. Allowed values: 'None', '1.0', '1.1', '1.2'
     */
    @JsonProperty(value = "minimalTlsVersion")
    private String minimalTlsVersion;

    /*
     * The storage account type used to store backups for this instance. The options are Local
     * (LocallyRedundantStorage), Zone (ZoneRedundantStorage), Geo (GeoRedundantStorage) and
     * GeoZone(GeoZoneRedundantStorage)
     */
    @JsonProperty(value = "currentBackupStorageRedundancy", access = JsonProperty.Access.WRITE_ONLY)
    private BackupStorageRedundancy currentBackupStorageRedundancy;

    /*
     * The storage account type to be used to store backups for this instance. The options are Local
     * (LocallyRedundantStorage), Zone (ZoneRedundantStorage), Geo (GeoRedundantStorage) and
     * GeoZone(GeoZoneRedundantStorage)
     */
    @JsonProperty(value = "requestedBackupStorageRedundancy")
    private BackupStorageRedundancy requestedBackupStorageRedundancy;

    /*
     * Whether or not the multi-az is enabled.
     */
    @JsonProperty(value = "zoneRedundant")
    private Boolean zoneRedundant;

    /*
     * The resource id of a user assigned identity to be used by default.
     */
    @JsonProperty(value = "primaryUserAssignedIdentityId")
    private String primaryUserAssignedIdentityId;

    /*
     * A CMK URI of the key to use for encryption.
     */
    @JsonProperty(value = "keyId")
    private String keyId;

    /*
     * The Azure Active Directory administrator of the server.
     */
    @JsonProperty(value = "administrators")
    private ManagedInstanceExternalAdministrator administrators;

    /*
     * The managed instance's service principal.
     */
    @JsonProperty(value = "servicePrincipal")
    private ServicePrincipal servicePrincipal;

    /** Creates an instance of ManagedInstanceProperties class. */
    public ManagedInstanceProperties() {
    }

    /**
     * Get the provisioningState property: The provisioningState property.
     *
     * @return the provisioningState value.
     */
    public ManagedInstancePropertiesProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the managedInstanceCreateMode property: Specifies the mode of database creation.
     *
     * <p>Default: Regular instance creation.
     *
     * <p>Restore: Creates an instance by restoring a set of backups to specific point in time. RestorePointInTime and
     * SourceManagedInstanceId must be specified.
     *
     * @return the managedInstanceCreateMode value.
     */
    public ManagedServerCreateMode managedInstanceCreateMode() {
        return this.managedInstanceCreateMode;
    }

    /**
     * Set the managedInstanceCreateMode property: Specifies the mode of database creation.
     *
     * <p>Default: Regular instance creation.
     *
     * <p>Restore: Creates an instance by restoring a set of backups to specific point in time. RestorePointInTime and
     * SourceManagedInstanceId must be specified.
     *
     * @param managedInstanceCreateMode the managedInstanceCreateMode value to set.
     * @return the ManagedInstanceProperties object itself.
     */
    public ManagedInstanceProperties withManagedInstanceCreateMode(ManagedServerCreateMode managedInstanceCreateMode) {
        this.managedInstanceCreateMode = managedInstanceCreateMode;
        return this;
    }

    /**
     * Get the fullyQualifiedDomainName property: The fully qualified domain name of the managed instance.
     *
     * @return the fullyQualifiedDomainName value.
     */
    public String fullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    /**
     * Get the administratorLogin property: Administrator username for the managed instance. Can only be specified when
     * the managed instance is being created (and is required for creation).
     *
     * @return the administratorLogin value.
     */
    public String administratorLogin() {
        return this.administratorLogin;
    }

    /**
     * Set the administratorLogin property: Administrator username for the managed instance. Can only be specified when
     * the managed instance is being created (and is required for creation).
     *
     * @param administratorLogin the administratorLogin value to set.
     * @return the ManagedInstanceProperties object itself.
     */
    public ManagedInstanceProperties withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    /**
     * Get the administratorLoginPassword property: The administrator login password (required for managed instance
     * creation).
     *
     * @return the administratorLoginPassword value.
     */
    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    /**
     * Set the administratorLoginPassword property: The administrator login password (required for managed instance
     * creation).
     *
     * @param administratorLoginPassword the administratorLoginPassword value to set.
     * @return the ManagedInstanceProperties object itself.
     */
    public ManagedInstanceProperties withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    /**
     * Get the subnetId property: Subnet resource ID for the managed instance.
     *
     * @return the subnetId value.
     */
    public String subnetId() {
        return this.subnetId;
    }

    /**
     * Set the subnetId property: Subnet resource ID for the managed instance.
     *
     * @param subnetId the subnetId value to set.
     * @return the ManagedInstanceProperties object itself.
     */
    public ManagedInstanceProperties withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    /**
     * Get the state property: The state of the managed instance.
     *
     * @return the state value.
     */
    public String state() {
        return this.state;
    }

    /**
     * Get the licenseType property: The license type. Possible values are 'LicenseIncluded' (regular price inclusive of
     * a new SQL license) and 'BasePrice' (discounted AHB price for bringing your own SQL licenses).
     *
     * @return the licenseType value.
     */
    public ManagedInstanceLicenseType licenseType() {
        return this.licenseType;
    }

    /**
     * Set the licenseType property: The license type. Possible values are 'LicenseIncluded' (regular price inclusive of
     * a new SQL license) and 'BasePrice' (discounted AHB price for bringing your own SQL licenses).
     *
     * @param licenseType the licenseType value to set.
     * @return the ManagedInstanceProperties object itself.
     */
    public ManagedInstanceProperties withLicenseType(ManagedInstanceLicenseType licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    /**
     * Get the vCores property: The number of vCores. Allowed values: 8, 16, 24, 32, 40, 64, 80.
     *
     * @return the vCores value.
     */
    public Integer vCores() {
        return this.vCores;
    }

    /**
     * Set the vCores property: The number of vCores. Allowed values: 8, 16, 24, 32, 40, 64, 80.
     *
     * @param vCores the vCores value to set.
     * @return the ManagedInstanceProperties object itself.
     */
    public ManagedInstanceProperties withVCores(Integer vCores) {
        this.vCores = vCores;
        return this;
    }

    /**
     * Get the storageSizeInGB property: Storage size in GB. Minimum value: 32. Maximum value: 16384. Increments of 32
     * GB allowed only. Maximum value depends on the selected hardware family and number of vCores.
     *
     * @return the storageSizeInGB value.
     */
    public Integer storageSizeInGB() {
        return this.storageSizeInGB;
    }

    /**
     * Set the storageSizeInGB property: Storage size in GB. Minimum value: 32. Maximum value: 16384. Increments of 32
     * GB allowed only. Maximum value depends on the selected hardware family and number of vCores.
     *
     * @param storageSizeInGB the storageSizeInGB value to set.
     * @return the ManagedInstanceProperties object itself.
     */
    public ManagedInstanceProperties withStorageSizeInGB(Integer storageSizeInGB) {
        this.storageSizeInGB = storageSizeInGB;
        return this;
    }

    /**
     * Get the collation property: Collation of the managed instance.
     *
     * @return the collation value.
     */
    public String collation() {
        return this.collation;
    }

    /**
     * Set the collation property: Collation of the managed instance.
     *
     * @param collation the collation value to set.
     * @return the ManagedInstanceProperties object itself.
     */
    public ManagedInstanceProperties withCollation(String collation) {
        this.collation = collation;
        return this;
    }

    /**
     * Get the dnsZone property: The Dns Zone that the managed instance is in.
     *
     * @return the dnsZone value.
     */
    public String dnsZone() {
        return this.dnsZone;
    }

    /**
     * Get the dnsZonePartner property: The resource id of another managed instance whose DNS zone this managed instance
     * will share after creation.
     *
     * @return the dnsZonePartner value.
     */
    public String dnsZonePartner() {
        return this.dnsZonePartner;
    }

    /**
     * Set the dnsZonePartner property: The resource id of another managed instance whose DNS zone this managed instance
     * will share after creation.
     *
     * @param dnsZonePartner the dnsZonePartner value to set.
     * @return the ManagedInstanceProperties object itself.
     */
    public ManagedInstanceProperties withDnsZonePartner(String dnsZonePartner) {
        this.dnsZonePartner = dnsZonePartner;
        return this;
    }

    /**
     * Get the publicDataEndpointEnabled property: Whether or not the public data endpoint is enabled.
     *
     * @return the publicDataEndpointEnabled value.
     */
    public Boolean publicDataEndpointEnabled() {
        return this.publicDataEndpointEnabled;
    }

    /**
     * Set the publicDataEndpointEnabled property: Whether or not the public data endpoint is enabled.
     *
     * @param publicDataEndpointEnabled the publicDataEndpointEnabled value to set.
     * @return the ManagedInstanceProperties object itself.
     */
    public ManagedInstanceProperties withPublicDataEndpointEnabled(Boolean publicDataEndpointEnabled) {
        this.publicDataEndpointEnabled = publicDataEndpointEnabled;
        return this;
    }

    /**
     * Get the sourceManagedInstanceId property: The resource identifier of the source managed instance associated with
     * create operation of this instance.
     *
     * @return the sourceManagedInstanceId value.
     */
    public String sourceManagedInstanceId() {
        return this.sourceManagedInstanceId;
    }

    /**
     * Set the sourceManagedInstanceId property: The resource identifier of the source managed instance associated with
     * create operation of this instance.
     *
     * @param sourceManagedInstanceId the sourceManagedInstanceId value to set.
     * @return the ManagedInstanceProperties object itself.
     */
    public ManagedInstanceProperties withSourceManagedInstanceId(String sourceManagedInstanceId) {
        this.sourceManagedInstanceId = sourceManagedInstanceId;
        return this;
    }

    /**
     * Get the restorePointInTime property: Specifies the point in time (ISO8601 format) of the source database that
     * will be restored to create the new database.
     *
     * @return the restorePointInTime value.
     */
    public OffsetDateTime restorePointInTime() {
        return this.restorePointInTime;
    }

    /**
     * Set the restorePointInTime property: Specifies the point in time (ISO8601 format) of the source database that
     * will be restored to create the new database.
     *
     * @param restorePointInTime the restorePointInTime value to set.
     * @return the ManagedInstanceProperties object itself.
     */
    public ManagedInstanceProperties withRestorePointInTime(OffsetDateTime restorePointInTime) {
        this.restorePointInTime = restorePointInTime;
        return this;
    }

    /**
     * Get the proxyOverride property: Connection type used for connecting to the instance.
     *
     * @return the proxyOverride value.
     */
    public ManagedInstanceProxyOverride proxyOverride() {
        return this.proxyOverride;
    }

    /**
     * Set the proxyOverride property: Connection type used for connecting to the instance.
     *
     * @param proxyOverride the proxyOverride value to set.
     * @return the ManagedInstanceProperties object itself.
     */
    public ManagedInstanceProperties withProxyOverride(ManagedInstanceProxyOverride proxyOverride) {
        this.proxyOverride = proxyOverride;
        return this;
    }

    /**
     * Get the timezoneId property: Id of the timezone. Allowed values are timezones supported by Windows. Windows keeps
     * details on supported timezones, including the id, in registry under KEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows
     * NT\CurrentVersion\Time Zones. You can get those registry values via SQL Server by querying SELECT name AS
     * timezone_id FROM sys.time_zone_info. List of Ids can also be obtained by executing
     * [System.TimeZoneInfo]::GetSystemTimeZones() in PowerShell. An example of valid timezone id is "Pacific Standard
     * Time" or "W. Europe Standard Time".
     *
     * @return the timezoneId value.
     */
    public String timezoneId() {
        return this.timezoneId;
    }

    /**
     * Set the timezoneId property: Id of the timezone. Allowed values are timezones supported by Windows. Windows keeps
     * details on supported timezones, including the id, in registry under KEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows
     * NT\CurrentVersion\Time Zones. You can get those registry values via SQL Server by querying SELECT name AS
     * timezone_id FROM sys.time_zone_info. List of Ids can also be obtained by executing
     * [System.TimeZoneInfo]::GetSystemTimeZones() in PowerShell. An example of valid timezone id is "Pacific Standard
     * Time" or "W. Europe Standard Time".
     *
     * @param timezoneId the timezoneId value to set.
     * @return the ManagedInstanceProperties object itself.
     */
    public ManagedInstanceProperties withTimezoneId(String timezoneId) {
        this.timezoneId = timezoneId;
        return this;
    }

    /**
     * Get the instancePoolId property: The Id of the instance pool this managed server belongs to.
     *
     * @return the instancePoolId value.
     */
    public String instancePoolId() {
        return this.instancePoolId;
    }

    /**
     * Set the instancePoolId property: The Id of the instance pool this managed server belongs to.
     *
     * @param instancePoolId the instancePoolId value to set.
     * @return the ManagedInstanceProperties object itself.
     */
    public ManagedInstanceProperties withInstancePoolId(String instancePoolId) {
        this.instancePoolId = instancePoolId;
        return this;
    }

    /**
     * Get the maintenanceConfigurationId property: Specifies maintenance configuration id to apply to this managed
     * instance.
     *
     * @return the maintenanceConfigurationId value.
     */
    public String maintenanceConfigurationId() {
        return this.maintenanceConfigurationId;
    }

    /**
     * Set the maintenanceConfigurationId property: Specifies maintenance configuration id to apply to this managed
     * instance.
     *
     * @param maintenanceConfigurationId the maintenanceConfigurationId value to set.
     * @return the ManagedInstanceProperties object itself.
     */
    public ManagedInstanceProperties withMaintenanceConfigurationId(String maintenanceConfigurationId) {
        this.maintenanceConfigurationId = maintenanceConfigurationId;
        return this;
    }

    /**
     * Get the privateEndpointConnections property: List of private endpoint connections on a managed instance.
     *
     * @return the privateEndpointConnections value.
     */
    public List<ManagedInstancePecProperty> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    /**
     * Get the minimalTlsVersion property: Minimal TLS version. Allowed values: 'None', '1.0', '1.1', '1.2'.
     *
     * @return the minimalTlsVersion value.
     */
    public String minimalTlsVersion() {
        return this.minimalTlsVersion;
    }

    /**
     * Set the minimalTlsVersion property: Minimal TLS version. Allowed values: 'None', '1.0', '1.1', '1.2'.
     *
     * @param minimalTlsVersion the minimalTlsVersion value to set.
     * @return the ManagedInstanceProperties object itself.
     */
    public ManagedInstanceProperties withMinimalTlsVersion(String minimalTlsVersion) {
        this.minimalTlsVersion = minimalTlsVersion;
        return this;
    }

    /**
     * Get the currentBackupStorageRedundancy property: The storage account type used to store backups for this
     * instance. The options are Local (LocallyRedundantStorage), Zone (ZoneRedundantStorage), Geo (GeoRedundantStorage)
     * and GeoZone(GeoZoneRedundantStorage).
     *
     * @return the currentBackupStorageRedundancy value.
     */
    public BackupStorageRedundancy currentBackupStorageRedundancy() {
        return this.currentBackupStorageRedundancy;
    }

    /**
     * Get the requestedBackupStorageRedundancy property: The storage account type to be used to store backups for this
     * instance. The options are Local (LocallyRedundantStorage), Zone (ZoneRedundantStorage), Geo (GeoRedundantStorage)
     * and GeoZone(GeoZoneRedundantStorage).
     *
     * @return the requestedBackupStorageRedundancy value.
     */
    public BackupStorageRedundancy requestedBackupStorageRedundancy() {
        return this.requestedBackupStorageRedundancy;
    }

    /**
     * Set the requestedBackupStorageRedundancy property: The storage account type to be used to store backups for this
     * instance. The options are Local (LocallyRedundantStorage), Zone (ZoneRedundantStorage), Geo (GeoRedundantStorage)
     * and GeoZone(GeoZoneRedundantStorage).
     *
     * @param requestedBackupStorageRedundancy the requestedBackupStorageRedundancy value to set.
     * @return the ManagedInstanceProperties object itself.
     */
    public ManagedInstanceProperties withRequestedBackupStorageRedundancy(
        BackupStorageRedundancy requestedBackupStorageRedundancy) {
        this.requestedBackupStorageRedundancy = requestedBackupStorageRedundancy;
        return this;
    }

    /**
     * Get the zoneRedundant property: Whether or not the multi-az is enabled.
     *
     * @return the zoneRedundant value.
     */
    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    /**
     * Set the zoneRedundant property: Whether or not the multi-az is enabled.
     *
     * @param zoneRedundant the zoneRedundant value to set.
     * @return the ManagedInstanceProperties object itself.
     */
    public ManagedInstanceProperties withZoneRedundant(Boolean zoneRedundant) {
        this.zoneRedundant = zoneRedundant;
        return this;
    }

    /**
     * Get the primaryUserAssignedIdentityId property: The resource id of a user assigned identity to be used by
     * default.
     *
     * @return the primaryUserAssignedIdentityId value.
     */
    public String primaryUserAssignedIdentityId() {
        return this.primaryUserAssignedIdentityId;
    }

    /**
     * Set the primaryUserAssignedIdentityId property: The resource id of a user assigned identity to be used by
     * default.
     *
     * @param primaryUserAssignedIdentityId the primaryUserAssignedIdentityId value to set.
     * @return the ManagedInstanceProperties object itself.
     */
    public ManagedInstanceProperties withPrimaryUserAssignedIdentityId(String primaryUserAssignedIdentityId) {
        this.primaryUserAssignedIdentityId = primaryUserAssignedIdentityId;
        return this;
    }

    /**
     * Get the keyId property: A CMK URI of the key to use for encryption.
     *
     * @return the keyId value.
     */
    public String keyId() {
        return this.keyId;
    }

    /**
     * Set the keyId property: A CMK URI of the key to use for encryption.
     *
     * @param keyId the keyId value to set.
     * @return the ManagedInstanceProperties object itself.
     */
    public ManagedInstanceProperties withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    /**
     * Get the administrators property: The Azure Active Directory administrator of the server.
     *
     * @return the administrators value.
     */
    public ManagedInstanceExternalAdministrator administrators() {
        return this.administrators;
    }

    /**
     * Set the administrators property: The Azure Active Directory administrator of the server.
     *
     * @param administrators the administrators value to set.
     * @return the ManagedInstanceProperties object itself.
     */
    public ManagedInstanceProperties withAdministrators(ManagedInstanceExternalAdministrator administrators) {
        this.administrators = administrators;
        return this;
    }

    /**
     * Get the servicePrincipal property: The managed instance's service principal.
     *
     * @return the servicePrincipal value.
     */
    public ServicePrincipal servicePrincipal() {
        return this.servicePrincipal;
    }

    /**
     * Set the servicePrincipal property: The managed instance's service principal.
     *
     * @param servicePrincipal the servicePrincipal value to set.
     * @return the ManagedInstanceProperties object itself.
     */
    public ManagedInstanceProperties withServicePrincipal(ServicePrincipal servicePrincipal) {
        this.servicePrincipal = servicePrincipal;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (privateEndpointConnections() != null) {
            privateEndpointConnections().forEach(e -> e.validate());
        }
        if (administrators() != null) {
            administrators().validate();
        }
        if (servicePrincipal() != null) {
            servicePrincipal().validate();
        }
    }
}
