// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.JobAgentState;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Properties of a job agent. */
@Fluent
public final class JobAgentProperties {
    /*
     * Resource ID of the database to store job metadata in.
     */
    @JsonProperty(value = "databaseId", required = true)
    private String databaseId;

    /*
     * The state of the job agent.
     */
    @JsonProperty(value = "state", access = JsonProperty.Access.WRITE_ONLY)
    private JobAgentState state;

    /** Creates an instance of JobAgentProperties class. */
    public JobAgentProperties() {
    }

    /**
     * Get the databaseId property: Resource ID of the database to store job metadata in.
     *
     * @return the databaseId value.
     */
    public String databaseId() {
        return this.databaseId;
    }

    /**
     * Set the databaseId property: Resource ID of the database to store job metadata in.
     *
     * @param databaseId the databaseId value to set.
     * @return the JobAgentProperties object itself.
     */
    public JobAgentProperties withDatabaseId(String databaseId) {
        this.databaseId = databaseId;
        return this;
    }

    /**
     * Get the state property: The state of the job agent.
     *
     * @return the state value.
     */
    public JobAgentState state() {
        return this.state;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (databaseId() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property databaseId in model JobAgentProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(JobAgentProperties.class);
}
