// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.InstanceFailoverGroupReadOnlyEndpoint;
import com.azure.resourcemanager.sql.models.InstanceFailoverGroupReadWriteEndpoint;
import com.azure.resourcemanager.sql.models.InstanceFailoverGroupReplicationRole;
import com.azure.resourcemanager.sql.models.ManagedInstancePairInfo;
import com.azure.resourcemanager.sql.models.PartnerRegionInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Properties of a instance failover group. */
@Fluent
public final class InstanceFailoverGroupProperties {
    /*
     * Read-write endpoint of the failover group instance.
     */
    @JsonProperty(value = "readWriteEndpoint", required = true)
    private InstanceFailoverGroupReadWriteEndpoint readWriteEndpoint;

    /*
     * Read-only endpoint of the failover group instance.
     */
    @JsonProperty(value = "readOnlyEndpoint")
    private InstanceFailoverGroupReadOnlyEndpoint readOnlyEndpoint;

    /*
     * Local replication role of the failover group instance.
     */
    @JsonProperty(value = "replicationRole", access = JsonProperty.Access.WRITE_ONLY)
    private InstanceFailoverGroupReplicationRole replicationRole;

    /*
     * Replication state of the failover group instance.
     */
    @JsonProperty(value = "replicationState", access = JsonProperty.Access.WRITE_ONLY)
    private String replicationState;

    /*
     * Partner region information for the failover group.
     */
    @JsonProperty(value = "partnerRegions", required = true)
    private List<PartnerRegionInfo> partnerRegions;

    /*
     * List of managed instance pairs in the failover group.
     */
    @JsonProperty(value = "managedInstancePairs", required = true)
    private List<ManagedInstancePairInfo> managedInstancePairs;

    /** Creates an instance of InstanceFailoverGroupProperties class. */
    public InstanceFailoverGroupProperties() {
    }

    /**
     * Get the readWriteEndpoint property: Read-write endpoint of the failover group instance.
     *
     * @return the readWriteEndpoint value.
     */
    public InstanceFailoverGroupReadWriteEndpoint readWriteEndpoint() {
        return this.readWriteEndpoint;
    }

    /**
     * Set the readWriteEndpoint property: Read-write endpoint of the failover group instance.
     *
     * @param readWriteEndpoint the readWriteEndpoint value to set.
     * @return the InstanceFailoverGroupProperties object itself.
     */
    public InstanceFailoverGroupProperties withReadWriteEndpoint(
        InstanceFailoverGroupReadWriteEndpoint readWriteEndpoint) {
        this.readWriteEndpoint = readWriteEndpoint;
        return this;
    }

    /**
     * Get the readOnlyEndpoint property: Read-only endpoint of the failover group instance.
     *
     * @return the readOnlyEndpoint value.
     */
    public InstanceFailoverGroupReadOnlyEndpoint readOnlyEndpoint() {
        return this.readOnlyEndpoint;
    }

    /**
     * Set the readOnlyEndpoint property: Read-only endpoint of the failover group instance.
     *
     * @param readOnlyEndpoint the readOnlyEndpoint value to set.
     * @return the InstanceFailoverGroupProperties object itself.
     */
    public InstanceFailoverGroupProperties withReadOnlyEndpoint(
        InstanceFailoverGroupReadOnlyEndpoint readOnlyEndpoint) {
        this.readOnlyEndpoint = readOnlyEndpoint;
        return this;
    }

    /**
     * Get the replicationRole property: Local replication role of the failover group instance.
     *
     * @return the replicationRole value.
     */
    public InstanceFailoverGroupReplicationRole replicationRole() {
        return this.replicationRole;
    }

    /**
     * Get the replicationState property: Replication state of the failover group instance.
     *
     * @return the replicationState value.
     */
    public String replicationState() {
        return this.replicationState;
    }

    /**
     * Get the partnerRegions property: Partner region information for the failover group.
     *
     * @return the partnerRegions value.
     */
    public List<PartnerRegionInfo> partnerRegions() {
        return this.partnerRegions;
    }

    /**
     * Set the partnerRegions property: Partner region information for the failover group.
     *
     * @param partnerRegions the partnerRegions value to set.
     * @return the InstanceFailoverGroupProperties object itself.
     */
    public InstanceFailoverGroupProperties withPartnerRegions(List<PartnerRegionInfo> partnerRegions) {
        this.partnerRegions = partnerRegions;
        return this;
    }

    /**
     * Get the managedInstancePairs property: List of managed instance pairs in the failover group.
     *
     * @return the managedInstancePairs value.
     */
    public List<ManagedInstancePairInfo> managedInstancePairs() {
        return this.managedInstancePairs;
    }

    /**
     * Set the managedInstancePairs property: List of managed instance pairs in the failover group.
     *
     * @param managedInstancePairs the managedInstancePairs value to set.
     * @return the InstanceFailoverGroupProperties object itself.
     */
    public InstanceFailoverGroupProperties withManagedInstancePairs(
        List<ManagedInstancePairInfo> managedInstancePairs) {
        this.managedInstancePairs = managedInstancePairs;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (readWriteEndpoint() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property readWriteEndpoint in model InstanceFailoverGroupProperties"));
        } else {
            readWriteEndpoint().validate();
        }
        if (readOnlyEndpoint() != null) {
            readOnlyEndpoint().validate();
        }
        if (partnerRegions() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property partnerRegions in model InstanceFailoverGroupProperties"));
        } else {
            partnerRegions().forEach(e -> e.validate());
        }
        if (managedInstancePairs() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property managedInstancePairs in model InstanceFailoverGroupProperties"));
        } else {
            managedInstancePairs().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(InstanceFailoverGroupProperties.class);
}
