// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.DatabaseVulnerabilityAssessmentRuleBaselineItem;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Properties of a database Vulnerability Assessment rule baseline. */
@Fluent
public final class DatabaseVulnerabilityAssessmentRuleBaselineProperties {
    /*
     * The rule baseline result
     */
    @JsonProperty(value = "baselineResults", required = true)
    private List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults;

    /** Creates an instance of DatabaseVulnerabilityAssessmentRuleBaselineProperties class. */
    public DatabaseVulnerabilityAssessmentRuleBaselineProperties() {
    }

    /**
     * Get the baselineResults property: The rule baseline result.
     *
     * @return the baselineResults value.
     */
    public List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults() {
        return this.baselineResults;
    }

    /**
     * Set the baselineResults property: The rule baseline result.
     *
     * @param baselineResults the baselineResults value to set.
     * @return the DatabaseVulnerabilityAssessmentRuleBaselineProperties object itself.
     */
    public DatabaseVulnerabilityAssessmentRuleBaselineProperties withBaselineResults(
        List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults) {
        this.baselineResults = baselineResults;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (baselineResults() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property baselineResults in model"
                            + " DatabaseVulnerabilityAssessmentRuleBaselineProperties"));
        } else {
            baselineResults().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER =
        new ClientLogger(DatabaseVulnerabilityAssessmentRuleBaselineProperties.class);
}
