// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentRecurringScansProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Properties of a database Vulnerability Assessment. */
@Fluent
public final class DatabaseVulnerabilityAssessmentProperties {
    /*
     * A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).
     * It is required if server level vulnerability assessment policy doesn't set
     */
    @JsonProperty(value = "storageContainerPath")
    private String storageContainerPath;

    /*
     * A shared access signature (SAS Key) that has write access to the blob container specified in
     * 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is
     * required. Applies only if the storage account is not behind a Vnet or a firewall
     */
    @JsonProperty(value = "storageContainerSasKey")
    private String storageContainerSasKey;

    /*
     * Specifies the identifier key of the storage account for vulnerability assessment scan results. If
     * 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required. Applies only if the storage
     * account is not behind a Vnet or a firewall
     */
    @JsonProperty(value = "storageAccountAccessKey")
    private String storageAccountAccessKey;

    /*
     * The recurring scans settings
     */
    @JsonProperty(value = "recurringScans")
    private VulnerabilityAssessmentRecurringScansProperties recurringScans;

    /** Creates an instance of DatabaseVulnerabilityAssessmentProperties class. */
    public DatabaseVulnerabilityAssessmentProperties() {
    }

    /**
     * Get the storageContainerPath property: A blob storage container path to hold the scan results (e.g.
     * https://myStorage.blob.core.windows.net/VaScans/). It is required if server level vulnerability assessment policy
     * doesn't set.
     *
     * @return the storageContainerPath value.
     */
    public String storageContainerPath() {
        return this.storageContainerPath;
    }

    /**
     * Set the storageContainerPath property: A blob storage container path to hold the scan results (e.g.
     * https://myStorage.blob.core.windows.net/VaScans/). It is required if server level vulnerability assessment policy
     * doesn't set.
     *
     * @param storageContainerPath the storageContainerPath value to set.
     * @return the DatabaseVulnerabilityAssessmentProperties object itself.
     */
    public DatabaseVulnerabilityAssessmentProperties withStorageContainerPath(String storageContainerPath) {
        this.storageContainerPath = storageContainerPath;
        return this;
    }

    /**
     * Get the storageContainerSasKey property: A shared access signature (SAS Key) that has write access to the blob
     * container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified,
     * StorageContainerSasKey is required. Applies only if the storage account is not behind a Vnet or a firewall.
     *
     * @return the storageContainerSasKey value.
     */
    public String storageContainerSasKey() {
        return this.storageContainerSasKey;
    }

    /**
     * Set the storageContainerSasKey property: A shared access signature (SAS Key) that has write access to the blob
     * container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified,
     * StorageContainerSasKey is required. Applies only if the storage account is not behind a Vnet or a firewall.
     *
     * @param storageContainerSasKey the storageContainerSasKey value to set.
     * @return the DatabaseVulnerabilityAssessmentProperties object itself.
     */
    public DatabaseVulnerabilityAssessmentProperties withStorageContainerSasKey(String storageContainerSasKey) {
        this.storageContainerSasKey = storageContainerSasKey;
        return this;
    }

    /**
     * Get the storageAccountAccessKey property: Specifies the identifier key of the storage account for vulnerability
     * assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
     * Applies only if the storage account is not behind a Vnet or a firewall.
     *
     * @return the storageAccountAccessKey value.
     */
    public String storageAccountAccessKey() {
        return this.storageAccountAccessKey;
    }

    /**
     * Set the storageAccountAccessKey property: Specifies the identifier key of the storage account for vulnerability
     * assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
     * Applies only if the storage account is not behind a Vnet or a firewall.
     *
     * @param storageAccountAccessKey the storageAccountAccessKey value to set.
     * @return the DatabaseVulnerabilityAssessmentProperties object itself.
     */
    public DatabaseVulnerabilityAssessmentProperties withStorageAccountAccessKey(String storageAccountAccessKey) {
        this.storageAccountAccessKey = storageAccountAccessKey;
        return this;
    }

    /**
     * Get the recurringScans property: The recurring scans settings.
     *
     * @return the recurringScans value.
     */
    public VulnerabilityAssessmentRecurringScansProperties recurringScans() {
        return this.recurringScans;
    }

    /**
     * Set the recurringScans property: The recurring scans settings.
     *
     * @param recurringScans the recurringScans value to set.
     * @return the DatabaseVulnerabilityAssessmentProperties object itself.
     */
    public DatabaseVulnerabilityAssessmentProperties withRecurringScans(
        VulnerabilityAssessmentRecurringScansProperties recurringScans) {
        this.recurringScans = recurringScans;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (recurringScans() != null) {
            recurringScans().validate();
        }
    }
}
