// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.NetworkIsolationSettings;
import com.azure.resourcemanager.sql.models.OperationMode;
import com.azure.resourcemanager.sql.models.StorageKeyType;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Contains the database information after a successful Import, Export, or PolybaseImport. */
@Fluent
public final class DatabaseExtensionsProperties {
    /*
     * Operation mode of the operation: Import, Export, or PolybaseImport.
     */
    @JsonProperty(value = "operationMode", required = true)
    private OperationMode operationMode;

    /*
     * Storage key type: StorageAccessKey or SharedAccessKey.
     */
    @JsonProperty(value = "storageKeyType", required = true)
    private StorageKeyType storageKeyType;

    /*
     * Storage key for the storage account.
     */
    @JsonProperty(value = "storageKey", required = true)
    private String storageKey;

    /*
     * Storage Uri for the storage account.
     */
    @JsonProperty(value = "storageUri", required = true)
    private String storageUri;

    /*
     * Administrator login name.
     */
    @JsonProperty(value = "administratorLogin")
    private String administratorLogin;

    /*
     * Administrator login password.
     */
    @JsonProperty(value = "administratorLoginPassword")
    private String administratorLoginPassword;

    /*
     * Authentication type: SQL authentication or AD password.
     */
    @JsonProperty(value = "authenticationType")
    private String authenticationType;

    /*
     * Database edition for the newly created database in the case of an import operation.
     */
    @JsonProperty(value = "databaseEdition")
    private String databaseEdition;

    /*
     * Database service level objective for the newly created database in the case of an import operation.
     */
    @JsonProperty(value = "serviceObjectiveName")
    private String serviceObjectiveName;

    /*
     * Database max size in bytes for the newly created database in the case of an import operation.
     */
    @JsonProperty(value = "maxSizeBytes")
    private String maxSizeBytes;

    /*
     * Optional resource information to enable network isolation for request.
     */
    @JsonProperty(value = "networkIsolation")
    private NetworkIsolationSettings networkIsolation;

    /** Creates an instance of DatabaseExtensionsProperties class. */
    public DatabaseExtensionsProperties() {
    }

    /**
     * Get the operationMode property: Operation mode of the operation: Import, Export, or PolybaseImport.
     *
     * @return the operationMode value.
     */
    public OperationMode operationMode() {
        return this.operationMode;
    }

    /**
     * Set the operationMode property: Operation mode of the operation: Import, Export, or PolybaseImport.
     *
     * @param operationMode the operationMode value to set.
     * @return the DatabaseExtensionsProperties object itself.
     */
    public DatabaseExtensionsProperties withOperationMode(OperationMode operationMode) {
        this.operationMode = operationMode;
        return this;
    }

    /**
     * Get the storageKeyType property: Storage key type: StorageAccessKey or SharedAccessKey.
     *
     * @return the storageKeyType value.
     */
    public StorageKeyType storageKeyType() {
        return this.storageKeyType;
    }

    /**
     * Set the storageKeyType property: Storage key type: StorageAccessKey or SharedAccessKey.
     *
     * @param storageKeyType the storageKeyType value to set.
     * @return the DatabaseExtensionsProperties object itself.
     */
    public DatabaseExtensionsProperties withStorageKeyType(StorageKeyType storageKeyType) {
        this.storageKeyType = storageKeyType;
        return this;
    }

    /**
     * Get the storageKey property: Storage key for the storage account.
     *
     * @return the storageKey value.
     */
    public String storageKey() {
        return this.storageKey;
    }

    /**
     * Set the storageKey property: Storage key for the storage account.
     *
     * @param storageKey the storageKey value to set.
     * @return the DatabaseExtensionsProperties object itself.
     */
    public DatabaseExtensionsProperties withStorageKey(String storageKey) {
        this.storageKey = storageKey;
        return this;
    }

    /**
     * Get the storageUri property: Storage Uri for the storage account.
     *
     * @return the storageUri value.
     */
    public String storageUri() {
        return this.storageUri;
    }

    /**
     * Set the storageUri property: Storage Uri for the storage account.
     *
     * @param storageUri the storageUri value to set.
     * @return the DatabaseExtensionsProperties object itself.
     */
    public DatabaseExtensionsProperties withStorageUri(String storageUri) {
        this.storageUri = storageUri;
        return this;
    }

    /**
     * Get the administratorLogin property: Administrator login name.
     *
     * @return the administratorLogin value.
     */
    public String administratorLogin() {
        return this.administratorLogin;
    }

    /**
     * Set the administratorLogin property: Administrator login name.
     *
     * @param administratorLogin the administratorLogin value to set.
     * @return the DatabaseExtensionsProperties object itself.
     */
    public DatabaseExtensionsProperties withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    /**
     * Get the administratorLoginPassword property: Administrator login password.
     *
     * @return the administratorLoginPassword value.
     */
    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    /**
     * Set the administratorLoginPassword property: Administrator login password.
     *
     * @param administratorLoginPassword the administratorLoginPassword value to set.
     * @return the DatabaseExtensionsProperties object itself.
     */
    public DatabaseExtensionsProperties withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    /**
     * Get the authenticationType property: Authentication type: SQL authentication or AD password.
     *
     * @return the authenticationType value.
     */
    public String authenticationType() {
        return this.authenticationType;
    }

    /**
     * Set the authenticationType property: Authentication type: SQL authentication or AD password.
     *
     * @param authenticationType the authenticationType value to set.
     * @return the DatabaseExtensionsProperties object itself.
     */
    public DatabaseExtensionsProperties withAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    /**
     * Get the databaseEdition property: Database edition for the newly created database in the case of an import
     * operation.
     *
     * @return the databaseEdition value.
     */
    public String databaseEdition() {
        return this.databaseEdition;
    }

    /**
     * Set the databaseEdition property: Database edition for the newly created database in the case of an import
     * operation.
     *
     * @param databaseEdition the databaseEdition value to set.
     * @return the DatabaseExtensionsProperties object itself.
     */
    public DatabaseExtensionsProperties withDatabaseEdition(String databaseEdition) {
        this.databaseEdition = databaseEdition;
        return this;
    }

    /**
     * Get the serviceObjectiveName property: Database service level objective for the newly created database in the
     * case of an import operation.
     *
     * @return the serviceObjectiveName value.
     */
    public String serviceObjectiveName() {
        return this.serviceObjectiveName;
    }

    /**
     * Set the serviceObjectiveName property: Database service level objective for the newly created database in the
     * case of an import operation.
     *
     * @param serviceObjectiveName the serviceObjectiveName value to set.
     * @return the DatabaseExtensionsProperties object itself.
     */
    public DatabaseExtensionsProperties withServiceObjectiveName(String serviceObjectiveName) {
        this.serviceObjectiveName = serviceObjectiveName;
        return this;
    }

    /**
     * Get the maxSizeBytes property: Database max size in bytes for the newly created database in the case of an import
     * operation.
     *
     * @return the maxSizeBytes value.
     */
    public String maxSizeBytes() {
        return this.maxSizeBytes;
    }

    /**
     * Set the maxSizeBytes property: Database max size in bytes for the newly created database in the case of an import
     * operation.
     *
     * @param maxSizeBytes the maxSizeBytes value to set.
     * @return the DatabaseExtensionsProperties object itself.
     */
    public DatabaseExtensionsProperties withMaxSizeBytes(String maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
        return this;
    }

    /**
     * Get the networkIsolation property: Optional resource information to enable network isolation for request.
     *
     * @return the networkIsolation value.
     */
    public NetworkIsolationSettings networkIsolation() {
        return this.networkIsolation;
    }

    /**
     * Set the networkIsolation property: Optional resource information to enable network isolation for request.
     *
     * @param networkIsolation the networkIsolation value to set.
     * @return the DatabaseExtensionsProperties object itself.
     */
    public DatabaseExtensionsProperties withNetworkIsolation(NetworkIsolationSettings networkIsolation) {
        this.networkIsolation = networkIsolation;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (operationMode() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property operationMode in model DatabaseExtensionsProperties"));
        }
        if (storageKeyType() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property storageKeyType in model DatabaseExtensionsProperties"));
        }
        if (storageKey() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property storageKey in model DatabaseExtensionsProperties"));
        }
        if (storageUri() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property storageUri in model DatabaseExtensionsProperties"));
        }
        if (networkIsolation() != null) {
            networkIsolation().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DatabaseExtensionsProperties.class);
}
