// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.sql.fluent.models.DatabaseAdvancedThreatProtectionInner;
import com.azure.resourcemanager.sql.models.AdvancedThreatProtectionName;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in
 * DatabaseAdvancedThreatProtectionSettingsClient.
 */
public interface DatabaseAdvancedThreatProtectionSettingsClient {
    /**
     * Gets a list of database's Advanced Threat Protection states.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of database's Advanced Threat Protection states as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DatabaseAdvancedThreatProtectionInner> listByDatabaseAsync(
        String resourceGroupName, String serverName, String databaseName);

    /**
     * Gets a list of database's Advanced Threat Protection states.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of database's Advanced Threat Protection states as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DatabaseAdvancedThreatProtectionInner> listByDatabase(
        String resourceGroupName, String serverName, String databaseName);

    /**
     * Gets a list of database's Advanced Threat Protection states.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of database's Advanced Threat Protection states as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DatabaseAdvancedThreatProtectionInner> listByDatabase(
        String resourceGroupName, String serverName, String databaseName, Context context);

    /**
     * Gets a database's Advanced Threat Protection state.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param advancedThreatProtectionName The name of the Advanced Threat Protection state.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database's Advanced Threat Protection state along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DatabaseAdvancedThreatProtectionInner>> getWithResponseAsync(
        String resourceGroupName,
        String serverName,
        String databaseName,
        AdvancedThreatProtectionName advancedThreatProtectionName);

    /**
     * Gets a database's Advanced Threat Protection state.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param advancedThreatProtectionName The name of the Advanced Threat Protection state.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database's Advanced Threat Protection state on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DatabaseAdvancedThreatProtectionInner> getAsync(
        String resourceGroupName,
        String serverName,
        String databaseName,
        AdvancedThreatProtectionName advancedThreatProtectionName);

    /**
     * Gets a database's Advanced Threat Protection state.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param advancedThreatProtectionName The name of the Advanced Threat Protection state.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database's Advanced Threat Protection state along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DatabaseAdvancedThreatProtectionInner> getWithResponse(
        String resourceGroupName,
        String serverName,
        String databaseName,
        AdvancedThreatProtectionName advancedThreatProtectionName,
        Context context);

    /**
     * Gets a database's Advanced Threat Protection state.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param advancedThreatProtectionName The name of the Advanced Threat Protection state.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database's Advanced Threat Protection state.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DatabaseAdvancedThreatProtectionInner get(
        String resourceGroupName,
        String serverName,
        String databaseName,
        AdvancedThreatProtectionName advancedThreatProtectionName);

    /**
     * Creates or updates a database's Advanced Threat Protection state.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param advancedThreatProtectionName The name of the Advanced Threat Protection state.
     * @param parameters The database Advanced Threat Protection state.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database Advanced Threat Protection along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DatabaseAdvancedThreatProtectionInner>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String serverName,
        String databaseName,
        AdvancedThreatProtectionName advancedThreatProtectionName,
        DatabaseAdvancedThreatProtectionInner parameters);

    /**
     * Creates or updates a database's Advanced Threat Protection state.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param advancedThreatProtectionName The name of the Advanced Threat Protection state.
     * @param parameters The database Advanced Threat Protection state.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database Advanced Threat Protection on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DatabaseAdvancedThreatProtectionInner> createOrUpdateAsync(
        String resourceGroupName,
        String serverName,
        String databaseName,
        AdvancedThreatProtectionName advancedThreatProtectionName,
        DatabaseAdvancedThreatProtectionInner parameters);

    /**
     * Creates or updates a database's Advanced Threat Protection state.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param advancedThreatProtectionName The name of the Advanced Threat Protection state.
     * @param parameters The database Advanced Threat Protection state.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database Advanced Threat Protection along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DatabaseAdvancedThreatProtectionInner> createOrUpdateWithResponse(
        String resourceGroupName,
        String serverName,
        String databaseName,
        AdvancedThreatProtectionName advancedThreatProtectionName,
        DatabaseAdvancedThreatProtectionInner parameters,
        Context context);

    /**
     * Creates or updates a database's Advanced Threat Protection state.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param advancedThreatProtectionName The name of the Advanced Threat Protection state.
     * @param parameters The database Advanced Threat Protection state.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database Advanced Threat Protection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DatabaseAdvancedThreatProtectionInner createOrUpdate(
        String resourceGroupName,
        String serverName,
        String databaseName,
        AdvancedThreatProtectionName advancedThreatProtectionName,
        DatabaseAdvancedThreatProtectionInner parameters);
}
