// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.sql.models.EndpointDependency;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** An endpoint that the managed instance service requires outbound network access to. */
@Immutable
public final class OutboundEnvironmentEndpointInner {
    /*
     * The type of service accessed by the managed instance service, e.g., Azure Storage, Azure Active Directory, etc.
     */
    @JsonProperty(value = "category", access = JsonProperty.Access.WRITE_ONLY)
    private String category;

    /*
     * The endpoints that the managed instance service communicates with in order to function correctly.
     */
    @JsonProperty(value = "endpoints", access = JsonProperty.Access.WRITE_ONLY)
    private List<EndpointDependency> endpoints;

    /** Creates an instance of OutboundEnvironmentEndpointInner class. */
    public OutboundEnvironmentEndpointInner() {
    }

    /**
     * Get the category property: The type of service accessed by the managed instance service, e.g., Azure Storage,
     * Azure Active Directory, etc.
     *
     * @return the category value.
     */
    public String category() {
        return this.category;
    }

    /**
     * Get the endpoints property: The endpoints that the managed instance service communicates with in order to
     * function correctly.
     *
     * @return the endpoints value.
     */
    public List<EndpointDependency> endpoints() {
        return this.endpoints;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (endpoints() != null) {
            endpoints().forEach(e -> e.validate());
        }
    }
}
