// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.sql.models.ManagedInstancePrivateEndpointProperty;
import com.azure.resourcemanager.sql.models.ManagedInstancePrivateLinkServiceConnectionStateProperty;
import com.fasterxml.jackson.annotation.JsonProperty;

/** A private endpoint connection. */
@Fluent
public final class ManagedInstancePrivateEndpointConnectionInner extends ProxyResource {
    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private ManagedInstancePrivateEndpointConnectionProperties innerProperties;

    /** Creates an instance of ManagedInstancePrivateEndpointConnectionInner class. */
    public ManagedInstancePrivateEndpointConnectionInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private ManagedInstancePrivateEndpointConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the privateEndpoint property: Private endpoint which the connection belongs to.
     *
     * @return the privateEndpoint value.
     */
    public ManagedInstancePrivateEndpointProperty privateEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpoint();
    }

    /**
     * Set the privateEndpoint property: Private endpoint which the connection belongs to.
     *
     * @param privateEndpoint the privateEndpoint value to set.
     * @return the ManagedInstancePrivateEndpointConnectionInner object itself.
     */
    public ManagedInstancePrivateEndpointConnectionInner withPrivateEndpoint(
        ManagedInstancePrivateEndpointProperty privateEndpoint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstancePrivateEndpointConnectionProperties();
        }
        this.innerProperties().withPrivateEndpoint(privateEndpoint);
        return this;
    }

    /**
     * Get the privateLinkServiceConnectionState property: Connection State of the Private Endpoint Connection.
     *
     * @return the privateLinkServiceConnectionState value.
     */
    public ManagedInstancePrivateLinkServiceConnectionStateProperty privateLinkServiceConnectionState() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkServiceConnectionState();
    }

    /**
     * Set the privateLinkServiceConnectionState property: Connection State of the Private Endpoint Connection.
     *
     * @param privateLinkServiceConnectionState the privateLinkServiceConnectionState value to set.
     * @return the ManagedInstancePrivateEndpointConnectionInner object itself.
     */
    public ManagedInstancePrivateEndpointConnectionInner withPrivateLinkServiceConnectionState(
        ManagedInstancePrivateLinkServiceConnectionStateProperty privateLinkServiceConnectionState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstancePrivateEndpointConnectionProperties();
        }
        this.innerProperties().withPrivateLinkServiceConnectionState(privateLinkServiceConnectionState);
        return this;
    }

    /**
     * Get the provisioningState property: State of the Private Endpoint Connection.
     *
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
