// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.sql.models.AutomaticTuningMode;
import com.azure.resourcemanager.sql.models.AutomaticTuningOptions;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** Database-level Automatic Tuning. */
@Fluent
public final class DatabaseAutomaticTuningInner extends ProxyResource {
    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private DatabaseAutomaticTuningProperties innerProperties;

    /** Creates an instance of DatabaseAutomaticTuningInner class. */
    public DatabaseAutomaticTuningInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private DatabaseAutomaticTuningProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the desiredState property: Automatic tuning desired state.
     *
     * @return the desiredState value.
     */
    public AutomaticTuningMode desiredState() {
        return this.innerProperties() == null ? null : this.innerProperties().desiredState();
    }

    /**
     * Set the desiredState property: Automatic tuning desired state.
     *
     * @param desiredState the desiredState value to set.
     * @return the DatabaseAutomaticTuningInner object itself.
     */
    public DatabaseAutomaticTuningInner withDesiredState(AutomaticTuningMode desiredState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAutomaticTuningProperties();
        }
        this.innerProperties().withDesiredState(desiredState);
        return this;
    }

    /**
     * Get the actualState property: Automatic tuning actual state.
     *
     * @return the actualState value.
     */
    public AutomaticTuningMode actualState() {
        return this.innerProperties() == null ? null : this.innerProperties().actualState();
    }

    /**
     * Get the options property: Automatic tuning options definition.
     *
     * @return the options value.
     */
    public Map<String, AutomaticTuningOptions> options() {
        return this.innerProperties() == null ? null : this.innerProperties().options();
    }

    /**
     * Set the options property: Automatic tuning options definition.
     *
     * @param options the options value to set.
     * @return the DatabaseAutomaticTuningInner object itself.
     */
    public DatabaseAutomaticTuningInner withOptions(Map<String, AutomaticTuningOptions> options) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseAutomaticTuningProperties();
        }
        this.innerProperties().withOptions(options);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
