// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.sql.fluent.models.DistributedAvailabilityGroupInner;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in DistributedAvailabilityGroupsClient. */
public interface DistributedAvailabilityGroupsClient {
    /**
     * Gets a list of a distributed availability groups in instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of a distributed availability groups in instance as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DistributedAvailabilityGroupInner> listByInstanceAsync(
        String resourceGroupName, String managedInstanceName);

    /**
     * Gets a list of a distributed availability groups in instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of a distributed availability groups in instance as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DistributedAvailabilityGroupInner> listByInstance(
        String resourceGroupName, String managedInstanceName);

    /**
     * Gets a list of a distributed availability groups in instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of a distributed availability groups in instance as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DistributedAvailabilityGroupInner> listByInstance(
        String resourceGroupName, String managedInstanceName, Context context);

    /**
     * Gets a distributed availability group info.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a distributed availability group info along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DistributedAvailabilityGroupInner>> getWithResponseAsync(
        String resourceGroupName, String managedInstanceName, String distributedAvailabilityGroupName);

    /**
     * Gets a distributed availability group info.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a distributed availability group info on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DistributedAvailabilityGroupInner> getAsync(
        String resourceGroupName, String managedInstanceName, String distributedAvailabilityGroupName);

    /**
     * Gets a distributed availability group info.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a distributed availability group info along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DistributedAvailabilityGroupInner> getWithResponse(
        String resourceGroupName, String managedInstanceName, String distributedAvailabilityGroupName, Context context);

    /**
     * Gets a distributed availability group info.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a distributed availability group info.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DistributedAvailabilityGroupInner get(
        String resourceGroupName, String managedInstanceName, String distributedAvailabilityGroupName);

    /**
     * Creates a distributed availability group between Sql On-Prem and Sql Managed Instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return distributed availability group between box and Sql Managed Instance along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String managedInstanceName,
        String distributedAvailabilityGroupName,
        DistributedAvailabilityGroupInner parameters);

    /**
     * Creates a distributed availability group between Sql On-Prem and Sql Managed Instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of distributed availability group between box and Sql Managed
     *     Instance.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<DistributedAvailabilityGroupInner>, DistributedAvailabilityGroupInner>
        beginCreateOrUpdateAsync(
            String resourceGroupName,
            String managedInstanceName,
            String distributedAvailabilityGroupName,
            DistributedAvailabilityGroupInner parameters);

    /**
     * Creates a distributed availability group between Sql On-Prem and Sql Managed Instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of distributed availability group between box and Sql Managed
     *     Instance.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DistributedAvailabilityGroupInner>, DistributedAvailabilityGroupInner> beginCreateOrUpdate(
        String resourceGroupName,
        String managedInstanceName,
        String distributedAvailabilityGroupName,
        DistributedAvailabilityGroupInner parameters);

    /**
     * Creates a distributed availability group between Sql On-Prem and Sql Managed Instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of distributed availability group between box and Sql Managed
     *     Instance.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DistributedAvailabilityGroupInner>, DistributedAvailabilityGroupInner> beginCreateOrUpdate(
        String resourceGroupName,
        String managedInstanceName,
        String distributedAvailabilityGroupName,
        DistributedAvailabilityGroupInner parameters,
        Context context);

    /**
     * Creates a distributed availability group between Sql On-Prem and Sql Managed Instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return distributed availability group between box and Sql Managed Instance on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DistributedAvailabilityGroupInner> createOrUpdateAsync(
        String resourceGroupName,
        String managedInstanceName,
        String distributedAvailabilityGroupName,
        DistributedAvailabilityGroupInner parameters);

    /**
     * Creates a distributed availability group between Sql On-Prem and Sql Managed Instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return distributed availability group between box and Sql Managed Instance.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DistributedAvailabilityGroupInner createOrUpdate(
        String resourceGroupName,
        String managedInstanceName,
        String distributedAvailabilityGroupName,
        DistributedAvailabilityGroupInner parameters);

    /**
     * Creates a distributed availability group between Sql On-Prem and Sql Managed Instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return distributed availability group between box and Sql Managed Instance.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DistributedAvailabilityGroupInner createOrUpdate(
        String resourceGroupName,
        String managedInstanceName,
        String distributedAvailabilityGroupName,
        DistributedAvailabilityGroupInner parameters,
        Context context);

    /**
     * Drops a distributed availability group between Sql On-Prem and Sql Managed Instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String managedInstanceName, String distributedAvailabilityGroupName);

    /**
     * Drops a distributed availability group between Sql On-Prem and Sql Managed Instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String managedInstanceName, String distributedAvailabilityGroupName);

    /**
     * Drops a distributed availability group between Sql On-Prem and Sql Managed Instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String managedInstanceName, String distributedAvailabilityGroupName);

    /**
     * Drops a distributed availability group between Sql On-Prem and Sql Managed Instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String managedInstanceName, String distributedAvailabilityGroupName, Context context);

    /**
     * Drops a distributed availability group between Sql On-Prem and Sql Managed Instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(
        String resourceGroupName, String managedInstanceName, String distributedAvailabilityGroupName);

    /**
     * Drops a distributed availability group between Sql On-Prem and Sql Managed Instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String managedInstanceName, String distributedAvailabilityGroupName);

    /**
     * Drops a distributed availability group between Sql On-Prem and Sql Managed Instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(
        String resourceGroupName, String managedInstanceName, String distributedAvailabilityGroupName, Context context);

    /**
     * Updates a distributed availability group replication mode.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return distributed availability group between box and Sql Managed Instance along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName,
        String managedInstanceName,
        String distributedAvailabilityGroupName,
        DistributedAvailabilityGroupInner parameters);

    /**
     * Updates a distributed availability group replication mode.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of distributed availability group between box and Sql Managed
     *     Instance.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<DistributedAvailabilityGroupInner>, DistributedAvailabilityGroupInner> beginUpdateAsync(
        String resourceGroupName,
        String managedInstanceName,
        String distributedAvailabilityGroupName,
        DistributedAvailabilityGroupInner parameters);

    /**
     * Updates a distributed availability group replication mode.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of distributed availability group between box and Sql Managed
     *     Instance.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DistributedAvailabilityGroupInner>, DistributedAvailabilityGroupInner> beginUpdate(
        String resourceGroupName,
        String managedInstanceName,
        String distributedAvailabilityGroupName,
        DistributedAvailabilityGroupInner parameters);

    /**
     * Updates a distributed availability group replication mode.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of distributed availability group between box and Sql Managed
     *     Instance.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DistributedAvailabilityGroupInner>, DistributedAvailabilityGroupInner> beginUpdate(
        String resourceGroupName,
        String managedInstanceName,
        String distributedAvailabilityGroupName,
        DistributedAvailabilityGroupInner parameters,
        Context context);

    /**
     * Updates a distributed availability group replication mode.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return distributed availability group between box and Sql Managed Instance on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DistributedAvailabilityGroupInner> updateAsync(
        String resourceGroupName,
        String managedInstanceName,
        String distributedAvailabilityGroupName,
        DistributedAvailabilityGroupInner parameters);

    /**
     * Updates a distributed availability group replication mode.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return distributed availability group between box and Sql Managed Instance.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DistributedAvailabilityGroupInner update(
        String resourceGroupName,
        String managedInstanceName,
        String distributedAvailabilityGroupName,
        DistributedAvailabilityGroupInner parameters);

    /**
     * Updates a distributed availability group replication mode.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return distributed availability group between box and Sql Managed Instance.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DistributedAvailabilityGroupInner update(
        String resourceGroupName,
        String managedInstanceName,
        String distributedAvailabilityGroupName,
        DistributedAvailabilityGroupInner parameters,
        Context context);
}
