// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** A domain name that the managed instance service needs to communicate with, along with additional details. */
@Immutable
public final class EndpointDependency {
    /*
     * The domain name of the dependency.
     */
    @JsonProperty(value = "domainName", access = JsonProperty.Access.WRITE_ONLY)
    private String domainName;

    /*
     * The IP Addresses and Ports used when connecting to DomainName.
     */
    @JsonProperty(value = "endpointDetails", access = JsonProperty.Access.WRITE_ONLY)
    private List<EndpointDetail> endpointDetails;

    /** Creates an instance of EndpointDependency class. */
    public EndpointDependency() {
    }

    /**
     * Get the domainName property: The domain name of the dependency.
     *
     * @return the domainName value.
     */
    public String domainName() {
        return this.domainName;
    }

    /**
     * Get the endpointDetails property: The IP Addresses and Ports used when connecting to DomainName.
     *
     * @return the endpointDetails value.
     */
    public List<EndpointDetail> endpointDetails() {
        return this.endpointDetails;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (endpointDetails() != null) {
            endpointDetails().forEach(e -> e.validate());
        }
    }
}
