// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.sql.models.QueryMetricInterval;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The QueryStatistics model. */
@Fluent
public final class QueryStatisticsInner extends ProxyResource {
    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private QueryStatisticsProperties innerProperties;

    /** Creates an instance of QueryStatisticsInner class. */
    public QueryStatisticsInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private QueryStatisticsProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the databaseName property: Database name of the database in which this query was executed.
     *
     * @return the databaseName value.
     */
    public String databaseName() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseName();
    }

    /**
     * Get the queryId property: Unique query id (unique within one database).
     *
     * @return the queryId value.
     */
    public String queryId() {
        return this.innerProperties() == null ? null : this.innerProperties().queryId();
    }

    /**
     * Get the startTime property: The start time for the metric (ISO-8601 format).
     *
     * @return the startTime value.
     */
    public String startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    /**
     * Get the endTime property: The end time for the metric (ISO-8601 format).
     *
     * @return the endTime value.
     */
    public String endTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endTime();
    }

    /**
     * Get the intervals property: List of intervals with appropriate metric data.
     *
     * @return the intervals value.
     */
    public List<QueryMetricInterval> intervals() {
        return this.innerProperties() == null ? null : this.innerProperties().intervals();
    }

    /**
     * Set the intervals property: List of intervals with appropriate metric data.
     *
     * @param intervals the intervals value to set.
     * @return the QueryStatisticsInner object itself.
     */
    public QueryStatisticsInner withIntervals(List<QueryMetricInterval> intervals) {
        if (this.innerProperties() == null) {
            this.innerProperties = new QueryStatisticsProperties();
        }
        this.innerProperties().withIntervals(intervals);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
