// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Represents the parameters for Unlink Replication Link request. */
@Fluent
public final class UnlinkParameters {
    /*
     * Determines whether link will be terminated in a forced or a friendly
     * way.
     */
    @JsonProperty(value = "forcedTermination")
    private Boolean forcedTermination;

    /**
     * Get the forcedTermination property: Determines whether link will be terminated in a forced or a friendly way.
     *
     * @return the forcedTermination value.
     */
    public Boolean forcedTermination() {
        return this.forcedTermination;
    }

    /**
     * Set the forcedTermination property: Determines whether link will be terminated in a forced or a friendly way.
     *
     * @param forcedTermination the forcedTermination value to set.
     * @return the UnlinkParameters object itself.
     */
    public UnlinkParameters withForcedTermination(Boolean forcedTermination) {
        this.forcedTermination = forcedTermination;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
