// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.fluent.models.TransparentDataEncryptionActivityInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Represents the response to a list database transparent data encryption activity request. */
@Fluent
public final class TransparentDataEncryptionActivityListResult {
    /*
     * The list of database transparent data encryption activities.
     */
    @JsonProperty(value = "value", required = true)
    private List<TransparentDataEncryptionActivityInner> value;

    /**
     * Get the value property: The list of database transparent data encryption activities.
     *
     * @return the value value.
     */
    public List<TransparentDataEncryptionActivityInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of database transparent data encryption activities.
     *
     * @param value the value value to set.
     * @return the TransparentDataEncryptionActivityListResult object itself.
     */
    public TransparentDataEncryptionActivityListResult withValue(List<TransparentDataEncryptionActivityInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property value in model TransparentDataEncryptionActivityListResult"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(TransparentDataEncryptionActivityListResult.class);
}
