// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Properties of column in sync group table. */
@Fluent
public final class SyncGroupSchemaTableColumn {
    /*
     * Quoted name of sync group table column.
     */
    @JsonProperty(value = "quotedName")
    private String quotedName;

    /*
     * Data size of the column.
     */
    @JsonProperty(value = "dataSize")
    private String dataSize;

    /*
     * Data type of the column.
     */
    @JsonProperty(value = "dataType")
    private String dataType;

    /**
     * Get the quotedName property: Quoted name of sync group table column.
     *
     * @return the quotedName value.
     */
    public String quotedName() {
        return this.quotedName;
    }

    /**
     * Set the quotedName property: Quoted name of sync group table column.
     *
     * @param quotedName the quotedName value to set.
     * @return the SyncGroupSchemaTableColumn object itself.
     */
    public SyncGroupSchemaTableColumn withQuotedName(String quotedName) {
        this.quotedName = quotedName;
        return this;
    }

    /**
     * Get the dataSize property: Data size of the column.
     *
     * @return the dataSize value.
     */
    public String dataSize() {
        return this.dataSize;
    }

    /**
     * Set the dataSize property: Data size of the column.
     *
     * @param dataSize the dataSize value to set.
     * @return the SyncGroupSchemaTableColumn object itself.
     */
    public SyncGroupSchemaTableColumn withDataSize(String dataSize) {
        this.dataSize = dataSize;
        return this;
    }

    /**
     * Get the dataType property: Data type of the column.
     *
     * @return the dataType value.
     */
    public String dataType() {
        return this.dataType;
    }

    /**
     * Set the dataType property: Data type of the column.
     *
     * @param dataType the dataType value to set.
     * @return the SyncGroupSchemaTableColumn object itself.
     */
    public SyncGroupSchemaTableColumn withDataType(String dataType) {
        this.dataType = dataType;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
