// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.fluent.models.MetricInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The response to a list database metrics request. */
@Fluent
public final class MetricListResult {
    /*
     * The list of metrics for the database.
     */
    @JsonProperty(value = "value", required = true)
    private List<MetricInner> value;

    /**
     * Get the value property: The list of metrics for the database.
     *
     * @return the value value.
     */
    public List<MetricInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of metrics for the database.
     *
     * @param value the value value to set.
     * @return the MetricListResult object itself.
     */
    public MetricListResult withValue(List<MetricInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property value in model MetricListResult"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(MetricListResult.class);
}
