// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.fluent.models.MetricDefinitionInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The response to a list database metric definitions request. */
@Fluent
public final class MetricDefinitionListResult {
    /*
     * The list of metric definitions for the database.
     */
    @JsonProperty(value = "value", required = true)
    private List<MetricDefinitionInner> value;

    /**
     * Get the value property: The list of metric definitions for the database.
     *
     * @return the value value.
     */
    public List<MetricDefinitionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of metric definitions for the database.
     *
     * @param value the value value to set.
     * @return the MetricDefinitionListResult object itself.
     */
    public MetricDefinitionListResult withValue(List<MetricDefinitionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property value in model MetricDefinitionListResult"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(MetricDefinitionListResult.class);
}
