// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Properties for an Azure SQL Database Vulnerability Assessment rule baseline's result. */
@Fluent
public final class DatabaseVulnerabilityAssessmentRuleBaselineItem {
    /*
     * The rule baseline result
     */
    @JsonProperty(value = "result", required = true)
    private List<String> result;

    /**
     * Get the result property: The rule baseline result.
     *
     * @return the result value.
     */
    public List<String> result() {
        return this.result;
    }

    /**
     * Set the result property: The rule baseline result.
     *
     * @param result the result value to set.
     * @return the DatabaseVulnerabilityAssessmentRuleBaselineItem object itself.
     */
    public DatabaseVulnerabilityAssessmentRuleBaselineItem withResult(List<String> result) {
        this.result = result;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (result() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property result in model DatabaseVulnerabilityAssessmentRuleBaselineItem"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DatabaseVulnerabilityAssessmentRuleBaselineItem.class);
}
