// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.sql.fluent.models.DatabaseProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;

/** A database resource. */
@Fluent
public final class DatabaseUpdate {
    /*
     * The name and tier of the SKU.
     */
    @JsonProperty(value = "sku")
    private Sku sku;

    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private DatabaseProperties innerProperties;

    /*
     * Resource tags.
     */
    @JsonProperty(value = "tags")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;

    /**
     * Get the sku property: The name and tier of the SKU.
     *
     * @return the sku value.
     */
    public Sku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: The name and tier of the SKU.
     *
     * @param sku the sku value to set.
     * @return the DatabaseUpdate object itself.
     */
    public DatabaseUpdate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private DatabaseProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the tags property: Resource tags.
     *
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Resource tags.
     *
     * @param tags the tags value to set.
     * @return the DatabaseUpdate object itself.
     */
    public DatabaseUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the createMode property: Specifies the mode of database creation.
     *
     * <p>Default: regular database creation.
     *
     * <p>Copy: creates a database as a copy of an existing database. sourceDatabaseId must be specified as the resource
     * ID of the source database.
     *
     * <p>Secondary: creates a database as a secondary replica of an existing database. sourceDatabaseId must be
     * specified as the resource ID of the existing primary database.
     *
     * <p>PointInTimeRestore: Creates a database by restoring a point in time backup of an existing database.
     * sourceDatabaseId must be specified as the resource ID of the existing database, and restorePointInTime must be
     * specified.
     *
     * <p>Recovery: Creates a database by restoring a geo-replicated backup. sourceDatabaseId must be specified as the
     * recoverable database resource ID to restore.
     *
     * <p>Restore: Creates a database by restoring a backup of a deleted database. sourceDatabaseId must be specified.
     * If sourceDatabaseId is the database's original resource ID, then sourceDatabaseDeletionDate must be specified.
     * Otherwise sourceDatabaseId must be the restorable dropped database resource ID and sourceDatabaseDeletionDate is
     * ignored. restorePointInTime may also be specified to restore from an earlier point in time.
     *
     * <p>RestoreLongTermRetentionBackup: Creates a database by restoring from a long term retention vault.
     * recoveryServicesRecoveryPointResourceId must be specified as the recovery point resource ID.
     *
     * <p>Copy, Secondary, and RestoreLongTermRetentionBackup are not supported for DataWarehouse edition.
     *
     * @return the createMode value.
     */
    public CreateMode createMode() {
        return this.innerProperties() == null ? null : this.innerProperties().createMode();
    }

    /**
     * Set the createMode property: Specifies the mode of database creation.
     *
     * <p>Default: regular database creation.
     *
     * <p>Copy: creates a database as a copy of an existing database. sourceDatabaseId must be specified as the resource
     * ID of the source database.
     *
     * <p>Secondary: creates a database as a secondary replica of an existing database. sourceDatabaseId must be
     * specified as the resource ID of the existing primary database.
     *
     * <p>PointInTimeRestore: Creates a database by restoring a point in time backup of an existing database.
     * sourceDatabaseId must be specified as the resource ID of the existing database, and restorePointInTime must be
     * specified.
     *
     * <p>Recovery: Creates a database by restoring a geo-replicated backup. sourceDatabaseId must be specified as the
     * recoverable database resource ID to restore.
     *
     * <p>Restore: Creates a database by restoring a backup of a deleted database. sourceDatabaseId must be specified.
     * If sourceDatabaseId is the database's original resource ID, then sourceDatabaseDeletionDate must be specified.
     * Otherwise sourceDatabaseId must be the restorable dropped database resource ID and sourceDatabaseDeletionDate is
     * ignored. restorePointInTime may also be specified to restore from an earlier point in time.
     *
     * <p>RestoreLongTermRetentionBackup: Creates a database by restoring from a long term retention vault.
     * recoveryServicesRecoveryPointResourceId must be specified as the recovery point resource ID.
     *
     * <p>Copy, Secondary, and RestoreLongTermRetentionBackup are not supported for DataWarehouse edition.
     *
     * @param createMode the createMode value to set.
     * @return the DatabaseUpdate object itself.
     */
    public DatabaseUpdate withCreateMode(CreateMode createMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withCreateMode(createMode);
        return this;
    }

    /**
     * Get the collation property: The collation of the database.
     *
     * @return the collation value.
     */
    public String collation() {
        return this.innerProperties() == null ? null : this.innerProperties().collation();
    }

    /**
     * Set the collation property: The collation of the database.
     *
     * @param collation the collation value to set.
     * @return the DatabaseUpdate object itself.
     */
    public DatabaseUpdate withCollation(String collation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withCollation(collation);
        return this;
    }

    /**
     * Get the maxSizeBytes property: The max size of the database expressed in bytes.
     *
     * @return the maxSizeBytes value.
     */
    public Long maxSizeBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().maxSizeBytes();
    }

    /**
     * Set the maxSizeBytes property: The max size of the database expressed in bytes.
     *
     * @param maxSizeBytes the maxSizeBytes value to set.
     * @return the DatabaseUpdate object itself.
     */
    public DatabaseUpdate withMaxSizeBytes(Long maxSizeBytes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withMaxSizeBytes(maxSizeBytes);
        return this;
    }

    /**
     * Get the sampleName property: The name of the sample schema to apply when creating this database.
     *
     * @return the sampleName value.
     */
    public SampleName sampleName() {
        return this.innerProperties() == null ? null : this.innerProperties().sampleName();
    }

    /**
     * Set the sampleName property: The name of the sample schema to apply when creating this database.
     *
     * @param sampleName the sampleName value to set.
     * @return the DatabaseUpdate object itself.
     */
    public DatabaseUpdate withSampleName(SampleName sampleName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withSampleName(sampleName);
        return this;
    }

    /**
     * Get the elasticPoolId property: The resource identifier of the elastic pool containing this database.
     *
     * @return the elasticPoolId value.
     */
    public String elasticPoolId() {
        return this.innerProperties() == null ? null : this.innerProperties().elasticPoolId();
    }

    /**
     * Set the elasticPoolId property: The resource identifier of the elastic pool containing this database.
     *
     * @param elasticPoolId the elasticPoolId value to set.
     * @return the DatabaseUpdate object itself.
     */
    public DatabaseUpdate withElasticPoolId(String elasticPoolId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withElasticPoolId(elasticPoolId);
        return this;
    }

    /**
     * Get the sourceDatabaseId property: The resource identifier of the source database associated with create
     * operation of this database.
     *
     * @return the sourceDatabaseId value.
     */
    public String sourceDatabaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceDatabaseId();
    }

    /**
     * Set the sourceDatabaseId property: The resource identifier of the source database associated with create
     * operation of this database.
     *
     * @param sourceDatabaseId the sourceDatabaseId value to set.
     * @return the DatabaseUpdate object itself.
     */
    public DatabaseUpdate withSourceDatabaseId(String sourceDatabaseId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withSourceDatabaseId(sourceDatabaseId);
        return this;
    }

    /**
     * Get the status property: The status of the database.
     *
     * @return the status value.
     */
    public DatabaseStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Get the databaseId property: The ID of the database.
     *
     * @return the databaseId value.
     */
    public UUID databaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseId();
    }

    /**
     * Get the creationDate property: The creation date of the database (ISO8601 format).
     *
     * @return the creationDate value.
     */
    public OffsetDateTime creationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().creationDate();
    }

    /**
     * Get the currentServiceObjectiveName property: The current service level objective name of the database.
     *
     * @return the currentServiceObjectiveName value.
     */
    public String currentServiceObjectiveName() {
        return this.innerProperties() == null ? null : this.innerProperties().currentServiceObjectiveName();
    }

    /**
     * Get the requestedServiceObjectiveName property: The requested service level objective name of the database.
     *
     * @return the requestedServiceObjectiveName value.
     */
    public String requestedServiceObjectiveName() {
        return this.innerProperties() == null ? null : this.innerProperties().requestedServiceObjectiveName();
    }

    /**
     * Get the defaultSecondaryLocation property: The default secondary region for this database.
     *
     * @return the defaultSecondaryLocation value.
     */
    public String defaultSecondaryLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultSecondaryLocation();
    }

    /**
     * Get the failoverGroupId property: Failover Group resource identifier that this database belongs to.
     *
     * @return the failoverGroupId value.
     */
    public String failoverGroupId() {
        return this.innerProperties() == null ? null : this.innerProperties().failoverGroupId();
    }

    /**
     * Get the restorePointInTime property: Specifies the point in time (ISO8601 format) of the source database that
     * will be restored to create the new database.
     *
     * @return the restorePointInTime value.
     */
    public OffsetDateTime restorePointInTime() {
        return this.innerProperties() == null ? null : this.innerProperties().restorePointInTime();
    }

    /**
     * Set the restorePointInTime property: Specifies the point in time (ISO8601 format) of the source database that
     * will be restored to create the new database.
     *
     * @param restorePointInTime the restorePointInTime value to set.
     * @return the DatabaseUpdate object itself.
     */
    public DatabaseUpdate withRestorePointInTime(OffsetDateTime restorePointInTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withRestorePointInTime(restorePointInTime);
        return this;
    }

    /**
     * Get the sourceDatabaseDeletionDate property: Specifies the time that the database was deleted.
     *
     * @return the sourceDatabaseDeletionDate value.
     */
    public OffsetDateTime sourceDatabaseDeletionDate() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceDatabaseDeletionDate();
    }

    /**
     * Set the sourceDatabaseDeletionDate property: Specifies the time that the database was deleted.
     *
     * @param sourceDatabaseDeletionDate the sourceDatabaseDeletionDate value to set.
     * @return the DatabaseUpdate object itself.
     */
    public DatabaseUpdate withSourceDatabaseDeletionDate(OffsetDateTime sourceDatabaseDeletionDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withSourceDatabaseDeletionDate(sourceDatabaseDeletionDate);
        return this;
    }

    /**
     * Get the recoveryServicesRecoveryPointId property: The resource identifier of the recovery point associated with
     * create operation of this database.
     *
     * @return the recoveryServicesRecoveryPointId value.
     */
    public String recoveryServicesRecoveryPointId() {
        return this.innerProperties() == null ? null : this.innerProperties().recoveryServicesRecoveryPointId();
    }

    /**
     * Set the recoveryServicesRecoveryPointId property: The resource identifier of the recovery point associated with
     * create operation of this database.
     *
     * @param recoveryServicesRecoveryPointId the recoveryServicesRecoveryPointId value to set.
     * @return the DatabaseUpdate object itself.
     */
    public DatabaseUpdate withRecoveryServicesRecoveryPointId(String recoveryServicesRecoveryPointId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withRecoveryServicesRecoveryPointId(recoveryServicesRecoveryPointId);
        return this;
    }

    /**
     * Get the longTermRetentionBackupResourceId property: The resource identifier of the long term retention backup
     * associated with create operation of this database.
     *
     * @return the longTermRetentionBackupResourceId value.
     */
    public String longTermRetentionBackupResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().longTermRetentionBackupResourceId();
    }

    /**
     * Set the longTermRetentionBackupResourceId property: The resource identifier of the long term retention backup
     * associated with create operation of this database.
     *
     * @param longTermRetentionBackupResourceId the longTermRetentionBackupResourceId value to set.
     * @return the DatabaseUpdate object itself.
     */
    public DatabaseUpdate withLongTermRetentionBackupResourceId(String longTermRetentionBackupResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withLongTermRetentionBackupResourceId(longTermRetentionBackupResourceId);
        return this;
    }

    /**
     * Get the recoverableDatabaseId property: The resource identifier of the recoverable database associated with
     * create operation of this database.
     *
     * @return the recoverableDatabaseId value.
     */
    public String recoverableDatabaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().recoverableDatabaseId();
    }

    /**
     * Set the recoverableDatabaseId property: The resource identifier of the recoverable database associated with
     * create operation of this database.
     *
     * @param recoverableDatabaseId the recoverableDatabaseId value to set.
     * @return the DatabaseUpdate object itself.
     */
    public DatabaseUpdate withRecoverableDatabaseId(String recoverableDatabaseId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withRecoverableDatabaseId(recoverableDatabaseId);
        return this;
    }

    /**
     * Get the restorableDroppedDatabaseId property: The resource identifier of the restorable dropped database
     * associated with create operation of this database.
     *
     * @return the restorableDroppedDatabaseId value.
     */
    public String restorableDroppedDatabaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().restorableDroppedDatabaseId();
    }

    /**
     * Set the restorableDroppedDatabaseId property: The resource identifier of the restorable dropped database
     * associated with create operation of this database.
     *
     * @param restorableDroppedDatabaseId the restorableDroppedDatabaseId value to set.
     * @return the DatabaseUpdate object itself.
     */
    public DatabaseUpdate withRestorableDroppedDatabaseId(String restorableDroppedDatabaseId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withRestorableDroppedDatabaseId(restorableDroppedDatabaseId);
        return this;
    }

    /**
     * Get the catalogCollation property: Collation of the metadata catalog.
     *
     * @return the catalogCollation value.
     */
    public CatalogCollationType catalogCollation() {
        return this.innerProperties() == null ? null : this.innerProperties().catalogCollation();
    }

    /**
     * Set the catalogCollation property: Collation of the metadata catalog.
     *
     * @param catalogCollation the catalogCollation value to set.
     * @return the DatabaseUpdate object itself.
     */
    public DatabaseUpdate withCatalogCollation(CatalogCollationType catalogCollation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withCatalogCollation(catalogCollation);
        return this;
    }

    /**
     * Get the zoneRedundant property: Whether or not this database is zone redundant, which means the replicas of this
     * database will be spread across multiple availability zones.
     *
     * @return the zoneRedundant value.
     */
    public Boolean zoneRedundant() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneRedundant();
    }

    /**
     * Set the zoneRedundant property: Whether or not this database is zone redundant, which means the replicas of this
     * database will be spread across multiple availability zones.
     *
     * @param zoneRedundant the zoneRedundant value to set.
     * @return the DatabaseUpdate object itself.
     */
    public DatabaseUpdate withZoneRedundant(Boolean zoneRedundant) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withZoneRedundant(zoneRedundant);
        return this;
    }

    /**
     * Get the licenseType property: The license type to apply for this database.
     *
     * @return the licenseType value.
     */
    public DatabaseLicenseType licenseType() {
        return this.innerProperties() == null ? null : this.innerProperties().licenseType();
    }

    /**
     * Set the licenseType property: The license type to apply for this database.
     *
     * @param licenseType the licenseType value to set.
     * @return the DatabaseUpdate object itself.
     */
    public DatabaseUpdate withLicenseType(DatabaseLicenseType licenseType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withLicenseType(licenseType);
        return this;
    }

    /**
     * Get the maxLogSizeBytes property: The max log size for this database.
     *
     * @return the maxLogSizeBytes value.
     */
    public Long maxLogSizeBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().maxLogSizeBytes();
    }

    /**
     * Get the earliestRestoreDate property: This records the earliest start date and time that restore is available for
     * this database (ISO8601 format).
     *
     * @return the earliestRestoreDate value.
     */
    public OffsetDateTime earliestRestoreDate() {
        return this.innerProperties() == null ? null : this.innerProperties().earliestRestoreDate();
    }

    /**
     * Get the readScale property: If enabled, connections that have application intent set to readonly in their
     * connection string may be routed to a readonly secondary replica. This property is only settable for Premium and
     * Business Critical databases.
     *
     * @return the readScale value.
     */
    public DatabaseReadScale readScale() {
        return this.innerProperties() == null ? null : this.innerProperties().readScale();
    }

    /**
     * Set the readScale property: If enabled, connections that have application intent set to readonly in their
     * connection string may be routed to a readonly secondary replica. This property is only settable for Premium and
     * Business Critical databases.
     *
     * @param readScale the readScale value to set.
     * @return the DatabaseUpdate object itself.
     */
    public DatabaseUpdate withReadScale(DatabaseReadScale readScale) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withReadScale(readScale);
        return this;
    }

    /**
     * Get the readReplicaCount property: The number of readonly secondary replicas associated with the database to
     * which readonly application intent connections may be routed. This property is only settable for Hyperscale
     * edition databases.
     *
     * @return the readReplicaCount value.
     */
    public Integer readReplicaCount() {
        return this.innerProperties() == null ? null : this.innerProperties().readReplicaCount();
    }

    /**
     * Set the readReplicaCount property: The number of readonly secondary replicas associated with the database to
     * which readonly application intent connections may be routed. This property is only settable for Hyperscale
     * edition databases.
     *
     * @param readReplicaCount the readReplicaCount value to set.
     * @return the DatabaseUpdate object itself.
     */
    public DatabaseUpdate withReadReplicaCount(Integer readReplicaCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withReadReplicaCount(readReplicaCount);
        return this;
    }

    /**
     * Get the currentSku property: The name and tier of the SKU.
     *
     * @return the currentSku value.
     */
    public Sku currentSku() {
        return this.innerProperties() == null ? null : this.innerProperties().currentSku();
    }

    /**
     * Get the autoPauseDelay property: Time in minutes after which database is automatically paused. A value of -1
     * means that automatic pause is disabled.
     *
     * @return the autoPauseDelay value.
     */
    public Integer autoPauseDelay() {
        return this.innerProperties() == null ? null : this.innerProperties().autoPauseDelay();
    }

    /**
     * Set the autoPauseDelay property: Time in minutes after which database is automatically paused. A value of -1
     * means that automatic pause is disabled.
     *
     * @param autoPauseDelay the autoPauseDelay value to set.
     * @return the DatabaseUpdate object itself.
     */
    public DatabaseUpdate withAutoPauseDelay(Integer autoPauseDelay) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withAutoPauseDelay(autoPauseDelay);
        return this;
    }

    /**
     * Get the minCapacity property: Minimal capacity that database will always have allocated, if not paused.
     *
     * @return the minCapacity value.
     */
    public Double minCapacity() {
        return this.innerProperties() == null ? null : this.innerProperties().minCapacity();
    }

    /**
     * Set the minCapacity property: Minimal capacity that database will always have allocated, if not paused.
     *
     * @param minCapacity the minCapacity value to set.
     * @return the DatabaseUpdate object itself.
     */
    public DatabaseUpdate withMinCapacity(Double minCapacity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withMinCapacity(minCapacity);
        return this;
    }

    /**
     * Get the pausedDate property: The date when database was paused by user configuration or action (ISO8601 format).
     * Null if the database is ready.
     *
     * @return the pausedDate value.
     */
    public OffsetDateTime pausedDate() {
        return this.innerProperties() == null ? null : this.innerProperties().pausedDate();
    }

    /**
     * Get the resumedDate property: The date when database was resumed by user action or database login (ISO8601
     * format). Null if the database is paused.
     *
     * @return the resumedDate value.
     */
    public OffsetDateTime resumedDate() {
        return this.innerProperties() == null ? null : this.innerProperties().resumedDate();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sku() != null) {
            sku().validate();
        }
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
