// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for DatabaseLicenseType. */
public final class DatabaseLicenseType extends ExpandableStringEnum<DatabaseLicenseType> {
    /** Static value LicenseIncluded for DatabaseLicenseType. */
    public static final DatabaseLicenseType LICENSE_INCLUDED = fromString("LicenseIncluded");

    /** Static value BasePrice for DatabaseLicenseType. */
    public static final DatabaseLicenseType BASE_PRICE = fromString("BasePrice");

    /**
     * Creates or finds a DatabaseLicenseType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding DatabaseLicenseType.
     */
    @JsonCreator
    public static DatabaseLicenseType fromString(String name) {
        return fromString(name, DatabaseLicenseType.class);
    }

    /**
     * Gets known DatabaseLicenseType values.
     *
     * @return known DatabaseLicenseType values.
     */
    public static Collection<DatabaseLicenseType> values() {
        return values(DatabaseLicenseType.class);
    }
}
