// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for ConnectionPolicyName. */
public final class ConnectionPolicyName extends ExpandableStringEnum<ConnectionPolicyName> {
    /** Static value default for ConnectionPolicyName. */
    public static final ConnectionPolicyName DEFAULT = fromString("default");

    /**
     * Creates or finds a ConnectionPolicyName from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ConnectionPolicyName.
     */
    @JsonCreator
    public static ConnectionPolicyName fromString(String name) {
        return fromString(name, ConnectionPolicyName.class);
    }

    /**
     * Gets known ConnectionPolicyName values.
     *
     * @return known ConnectionPolicyName values.
     */
    public static Collection<ConnectionPolicyName> values() {
        return values(ConnectionPolicyName.class);
    }
}
