// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Workload group definition. For more information look at sys.workload_management_workload_groups (DMV). */
@Fluent
public final class WorkloadGroupProperties {
    /*
     * The workload group minimum percentage resource.
     */
    @JsonProperty(value = "minResourcePercent", required = true)
    private int minResourcePercent;

    /*
     * The workload group cap percentage resource.
     */
    @JsonProperty(value = "maxResourcePercent", required = true)
    private int maxResourcePercent;

    /*
     * The workload group request minimum grant percentage.
     */
    @JsonProperty(value = "minResourcePercentPerRequest", required = true)
    private double minResourcePercentPerRequest;

    /*
     * The workload group request maximum grant percentage.
     */
    @JsonProperty(value = "maxResourcePercentPerRequest")
    private Double maxResourcePercentPerRequest;

    /*
     * The workload group importance level.
     */
    @JsonProperty(value = "importance")
    private String importance;

    /*
     * The workload group query execution timeout.
     */
    @JsonProperty(value = "queryExecutionTimeout")
    private Integer queryExecutionTimeout;

    /**
     * Get the minResourcePercent property: The workload group minimum percentage resource.
     *
     * @return the minResourcePercent value.
     */
    public int minResourcePercent() {
        return this.minResourcePercent;
    }

    /**
     * Set the minResourcePercent property: The workload group minimum percentage resource.
     *
     * @param minResourcePercent the minResourcePercent value to set.
     * @return the WorkloadGroupProperties object itself.
     */
    public WorkloadGroupProperties withMinResourcePercent(int minResourcePercent) {
        this.minResourcePercent = minResourcePercent;
        return this;
    }

    /**
     * Get the maxResourcePercent property: The workload group cap percentage resource.
     *
     * @return the maxResourcePercent value.
     */
    public int maxResourcePercent() {
        return this.maxResourcePercent;
    }

    /**
     * Set the maxResourcePercent property: The workload group cap percentage resource.
     *
     * @param maxResourcePercent the maxResourcePercent value to set.
     * @return the WorkloadGroupProperties object itself.
     */
    public WorkloadGroupProperties withMaxResourcePercent(int maxResourcePercent) {
        this.maxResourcePercent = maxResourcePercent;
        return this;
    }

    /**
     * Get the minResourcePercentPerRequest property: The workload group request minimum grant percentage.
     *
     * @return the minResourcePercentPerRequest value.
     */
    public double minResourcePercentPerRequest() {
        return this.minResourcePercentPerRequest;
    }

    /**
     * Set the minResourcePercentPerRequest property: The workload group request minimum grant percentage.
     *
     * @param minResourcePercentPerRequest the minResourcePercentPerRequest value to set.
     * @return the WorkloadGroupProperties object itself.
     */
    public WorkloadGroupProperties withMinResourcePercentPerRequest(double minResourcePercentPerRequest) {
        this.minResourcePercentPerRequest = minResourcePercentPerRequest;
        return this;
    }

    /**
     * Get the maxResourcePercentPerRequest property: The workload group request maximum grant percentage.
     *
     * @return the maxResourcePercentPerRequest value.
     */
    public Double maxResourcePercentPerRequest() {
        return this.maxResourcePercentPerRequest;
    }

    /**
     * Set the maxResourcePercentPerRequest property: The workload group request maximum grant percentage.
     *
     * @param maxResourcePercentPerRequest the maxResourcePercentPerRequest value to set.
     * @return the WorkloadGroupProperties object itself.
     */
    public WorkloadGroupProperties withMaxResourcePercentPerRequest(Double maxResourcePercentPerRequest) {
        this.maxResourcePercentPerRequest = maxResourcePercentPerRequest;
        return this;
    }

    /**
     * Get the importance property: The workload group importance level.
     *
     * @return the importance value.
     */
    public String importance() {
        return this.importance;
    }

    /**
     * Set the importance property: The workload group importance level.
     *
     * @param importance the importance value to set.
     * @return the WorkloadGroupProperties object itself.
     */
    public WorkloadGroupProperties withImportance(String importance) {
        this.importance = importance;
        return this;
    }

    /**
     * Get the queryExecutionTimeout property: The workload group query execution timeout.
     *
     * @return the queryExecutionTimeout value.
     */
    public Integer queryExecutionTimeout() {
        return this.queryExecutionTimeout;
    }

    /**
     * Set the queryExecutionTimeout property: The workload group query execution timeout.
     *
     * @param queryExecutionTimeout the queryExecutionTimeout value to set.
     * @return the WorkloadGroupProperties object itself.
     */
    public WorkloadGroupProperties withQueryExecutionTimeout(Integer queryExecutionTimeout) {
        this.queryExecutionTimeout = queryExecutionTimeout;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
